package qouteall.imm_ptl.peripheral.wand;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.mc_utils.WireRenderingHelper;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.IntBox;

import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class WandUtil {
    
    @Nullable
    @Environment(EnvType.CLIENT)
    public static Portal getClientPortalByUUID(UUID portalId) {
        class_746 player = class_310.method_1551().field_1724;
        
        if (player == null) {
            return null;
        }
    
        class_1937 world = player.method_37908();
    
        return getPortalByUUID(world, portalId);
    }
    
    @Nullable
    public static Portal getPortalByUUID(class_1937 world, UUID portalId) {
        if (portalId == null) {
            return null;
        }
        
        class_1297 entity = McHelper.getEntityByUUID(world, portalId);
        
        if (entity instanceof Portal portal) {
            return portal;
        }
        else {
            return null;
        }
    }
    
    public static class_243 alignOnBlocks(
        class_1937 world, class_243 vec3, int gridCount
    ) {
        if (gridCount == 0) {
            return vec3;
        }
        
        class_2338 blockPos = class_2338.method_49638(vec3);
        return new IntBox(blockPos.method_10069(-1, -1, -1), blockPos.method_10069(1, 1, 1))
            .stream()
            .flatMap(
                pos -> {
                    class_2680 blockState = world.method_8320(pos);
                    class_265 collisionShape = blockState.method_26220(world, pos)
                        .method_1096(pos.method_10263(), pos.method_10264(), pos.method_10260());
                    List<class_238> aabbs = collisionShape.method_1090();
                    if (aabbs.size() != 1) {
                        // in the case of hopper, not all of its collision boxes are symmetric
                        // without this, the north and south side of top edge mid-point of hopper cannot be selected
                        // also make air blocks alignable
                        aabbs.add(new class_238(pos));
                    }
                    return aabbs.stream();
                }
            )
            .map(box -> Helper.alignToBoxSurface(box, vec3, gridCount))
            .min(
                Comparator.comparingDouble(
                    p -> p.method_1025(vec3)
                )
            ).orElse(null);
    }
    
    @Environment(EnvType.CLIENT)
    public static void renderPortalAreaGridNew(
        class_4588 vertexConsumer, class_243 cameraPos,
        ProtoPortalSide protoPortalSide,
        int color1, int color2, class_4587 matrixStack
    ) {
        int separation = 8;
        
        class_243 leftBottom = protoPortalSide.leftBottom;
        class_243 rightBottom = protoPortalSide.rightBottom;
        class_243 leftTop = protoPortalSide.leftTop;
        
        class_243 xAxis = rightBottom.method_1020(leftBottom);
        class_243 yAxis = leftTop.method_1020(leftBottom);
        
        class_243 normal = xAxis.method_1036(yAxis).method_1029();
        
        matrixStack.method_22903();
        matrixStack.method_22904(
            leftBottom.field_1352 - cameraPos.field_1352,
            leftBottom.field_1351 - cameraPos.field_1351,
            leftBottom.field_1350 - cameraPos.field_1350
        );
        
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Matrix3f normalMatrix = matrixStack.method_23760().method_23762();
        
        // render the outer frame
        WireRenderingHelper.putLine(
            vertexConsumer, color1, matrix, normalMatrix,
            class_243.field_1353, xAxis
        );
        WireRenderingHelper.putLine(
            vertexConsumer, color1, matrix, normalMatrix,
            yAxis, yAxis.method_1019(xAxis)
        );
        WireRenderingHelper.putLine(
            vertexConsumer, color1, matrix, normalMatrix,
            class_243.field_1353, yAxis
        );
        WireRenderingHelper.putLine(
            vertexConsumer, color1, matrix, normalMatrix,
            xAxis, yAxis.method_1019(xAxis)
        );
        
        // render the inner grid flow lines
        int flowCount = 3;
        Random random = new Random(color1);
        
        double scaling = 0.994;
        double offset1 = (1 - scaling) / 2;
        double offset2 = -offset1;
        
        for (int cx = 1; cx < separation; cx++) {
            double lx = ((double) cx) / separation;
            WireRenderingHelper.renderFlowLines(
                vertexConsumer,
                new class_243[]{
                    xAxis.method_1021(lx * scaling + offset1),
                    xAxis.method_1021(lx * scaling + offset1).method_1019(yAxis),
                },
                flowCount, color1, 1, matrixStack,
                () -> random.nextInt(10, 100)
            );
    
            WireRenderingHelper.renderFlowLines(
                vertexConsumer,
                new class_243[]{
                    xAxis.method_1021(lx * scaling + offset2),
                    xAxis.method_1021(lx * scaling + offset2).method_1019(yAxis),
                },
                flowCount, color2, -1, matrixStack,
                () -> random.nextInt(10, 100)
            );
        }
        
        for (int cy = 1; cy < separation; cy++) {
            double ly = ((double) cy) / separation;
            WireRenderingHelper.renderFlowLines(
                vertexConsumer,
                new class_243[]{
                    yAxis.method_1021(ly * scaling + offset1),
                    yAxis.method_1021(ly * scaling + offset1).method_1019(xAxis),
                },
                flowCount, color1, 1, matrixStack,
                () -> random.nextInt(10, 100)
            );
    
            WireRenderingHelper.renderFlowLines(
                vertexConsumer,
                new class_243[]{
                    yAxis.method_1021(ly * scaling + offset2),
                    yAxis.method_1021(ly * scaling + offset2).method_1019(xAxis),
                },
                flowCount, color2, -1, matrixStack,
                () -> random.nextInt(10, 100)
            );
        }
        
        matrixStack.method_22909();
    }
    
    @Environment(EnvType.CLIENT)
    public static void renderPortalAreaGrid(
        class_4588 vertexConsumer, class_243 cameraPos,
        ProtoPortalSide protoPortalSide,
        int color, class_4587 matrixStack
    ) {
        int separation = 8;
        
        class_243 leftBottom = protoPortalSide.leftBottom;
        class_243 rightBottom = protoPortalSide.rightBottom;
        class_243 leftTop = protoPortalSide.leftTop;
        
        class_243 xAxis = rightBottom.method_1020(leftBottom);
        class_243 yAxis = leftTop.method_1020(leftBottom);
        
        class_243 normal = xAxis.method_1036(yAxis).method_1029();
        
        matrixStack.method_22903();
        matrixStack.method_22904(
            leftBottom.field_1352 - cameraPos.field_1352,
            leftBottom.field_1351 - cameraPos.field_1351,
            leftBottom.field_1350 - cameraPos.field_1350
        );
        
        Matrix4f matrix = matrixStack.method_23760().method_23761();
        Matrix3f normalMatrix = matrixStack.method_23760().method_23762();
        
        for (int i = 0; i <= separation; i++) {
            double ratio = (double) i / separation;
            
            class_243 lineStart = xAxis.method_1021(ratio);
            class_243 lineEnd = xAxis.method_1021(ratio).method_1019(yAxis);
            
            WireRenderingHelper.putLine(vertexConsumer, color, yAxis.method_1029(), matrix, normalMatrix, lineStart, lineEnd);
        }
        
        for (int i = 0; i <= separation; i++) {
            double ratio = (double) i / separation;
            
            class_243 lineStart = yAxis.method_1021(ratio);
            class_243 lineEnd = yAxis.method_1021(ratio).method_1019(xAxis);
            
            WireRenderingHelper.putLine(vertexConsumer, color, xAxis.method_1029(), matrix, normalMatrix, lineStart, lineEnd);
        }
        
        matrixStack.method_22909();
    }
}
