/*
 * Decompiled with CFR 0.152.
 */
package dev.lyki;

import dev.lyki.TotemPlus;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class TotemConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("totem-plus.properties");
    public static int TOTEM_COOLDOWN_TICKS = 600;

    public static void loadConfig() {
        Properties properties = new Properties();
        if (CONFIG_PATH.toFile().exists()) {
            try (FileInputStream stream = new FileInputStream(CONFIG_PATH.toFile());){
                properties.load(stream);
                int cooldownSeconds = Integer.parseInt(properties.getProperty("totem-cooldown-seconds", "30"));
                TOTEM_COOLDOWN_TICKS = cooldownSeconds * 20;
            }
            catch (IOException e) {
                TotemPlus.LOGGER.error("Error while loading TotemPlus configuration!", (Throwable)e);
            }
        } else {
            properties.setProperty("totem-cooldown-seconds", "30");
            TotemConfig.saveConfig(properties);
        }
    }

    private static void saveConfig(Properties properties) {
        try (FileOutputStream stream = new FileOutputStream(CONFIG_PATH.toFile());){
            properties.store(stream, "TotemPlus Configuration");
        }
        catch (IOException e) {
            TotemPlus.LOGGER.error("Error while saving TotemPlus configuration!", (Throwable)e);
        }
    }
}

