/*
 * Decompiled with CFR 0.152.
 */
package fourmisain.dirtnt;

import fourmisain.dirtnt.block.DirtTntBlock;
import fourmisain.dirtnt.config.DirTntConfig;
import fourmisain.dirtnt.config.GsonConfigHelper;
import fourmisain.dirtnt.entity.DirtTntEntity;
import fourmisain.dirtnt.mixin.FireBlockAccessor;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1541;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DirTnt
implements ModInitializer {
    public static final String MOD_ID = "dirtnt";
    public static final Logger LOGGER = LogManager.getLogger((String)"dirtnt");
    public static final Set<class_2960> DIRT_TYPES = new LinkedHashSet<class_2960>();
    public static class_2960 dirtyOverride = null;
    public static final Map<class_2960, DirtTntBlock> BLOCK_MAP = new HashMap<class_2960, DirtTntBlock>();
    public static final Map<class_2960, class_1792> ITEM_MAP = new HashMap<class_2960, class_1792>();
    public static final Map<class_2960, class_1299<DirtTntEntity>> ENTITY_TYPE_MAP = new HashMap<class_2960, class_1299<DirtTntEntity>>();

    public static class_2960 id(String id) {
        return class_2960.method_60655((String)MOD_ID, (String)id);
    }

    public static class_2960 getDirtTntBlockId(class_2960 dirtType) {
        String namespace = dirtType.method_12836();
        if (namespace.equals("minecraft")) {
            return DirTnt.id(String.format("%s_tnt", dirtType.method_12832()));
        }
        return DirTnt.id(String.format("%s_%s_tnt", namespace, dirtType.method_12832()));
    }

    public static void loadConfig() {
        DirTntConfig config = new DirTntConfig();
        GsonConfigHelper configHelper = new GsonConfigHelper(MOD_ID);
        if (configHelper.exists()) {
            try {
                config = configHelper.load(DirTntConfig.class);
            }
            catch (IOException e) {
                LOGGER.error("couldn't load config", (Throwable)e);
            }
        } else {
            try {
                configHelper.save(config);
            }
            catch (IOException e) {
                LOGGER.error("couldn't save config", (Throwable)e);
            }
        }
        DIRT_TYPES.clear();
        DIRT_TYPES.addAll(config.dirtTypes);
        if (config.enableAll) {
            DIRT_TYPES.addAll(class_7923.field_41175.method_10235());
        }
    }

    public void onInitialize() {
        DirTnt.loadConfig();
        FireBlockAccessor fireBlock = (FireBlockAccessor)class_2246.field_10036;
        for (class_2960 dirtType : DIRT_TYPES) {
            class_2960 id = DirTnt.getDirtTntBlockId(dirtType);
            DirtTntBlock block = (DirtTntBlock)((Object)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)id, (Object)((Object)new DirtTntBlock(DirtTntBlock.getDefaultSettings().method_63500(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)id)), dirtType))));
            class_1792 item = class_1802.method_7992((class_2248)block, (class_1792.class_1793)new class_1792.class_1793().method_63686(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)id)));
            class_1299 entityType = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)id, this.createDirtTntEntityType(dirtType, id));
            BLOCK_MAP.put(dirtType, block);
            ITEM_MAP.put(dirtType, item);
            ENTITY_TYPE_MAP.put(dirtType, (class_1299<DirtTntEntity>)entityType);
            class_2315.method_10009((class_1935)item, (pointer, stack) -> DirTnt.dispenseDirtTnt(dirtType, pointer, stack));
            fireBlock.invokeRegisterFlammableBlock((class_2248)block, 15, 100);
        }
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40198).register(entries -> {
            for (class_2960 dirtType : DIRT_TYPES) {
                entries.method_45421((class_1935)ITEM_MAP.get(dirtType));
            }
        });
    }

    private static class_1799 dispenseDirtTnt(class_2960 dirtType, class_2342 pointer, class_1799 stack) {
        class_3218 world = pointer.comp_1967();
        class_2338 pos = pointer.comp_1968().method_10093((class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918));
        DirtTntEntity tntEntity = new DirtTntEntity(dirtType, (class_1937)world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
        world.method_8649((class_1297)tntEntity);
        world.method_43128(null, tntEntity.method_23317(), tntEntity.method_23318(), tntEntity.method_23321(), class_3417.field_15079, class_3419.field_15245, 1.0f, 1.0f);
        world.method_33596(null, (class_6880)class_5712.field_28738, pos);
        stack.method_7934(1);
        return stack;
    }

    private class_1299<DirtTntEntity> createDirtTntEntityType(class_2960 dirtType, class_2960 id) {
        return class_1299.class_1300.method_5903((entityType, world) -> new DirtTntEntity(dirtType, (class_1299<? extends class_1541>)entityType, world), (class_1311)class_1311.field_17715).method_63006().method_19947().method_17687(0.98f, 0.98f).method_55687(0.15f).method_27299(10).method_27300(10).method_5905(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id));
    }

    public static String getRecipeJson(class_2960 dirtType, class_2960 itemId) {
        return "{\n  \"type\": \"minecraft:crafting_shaped\",\n  \"category\": \"redstone\",\n  \"pattern\": [\n    \"###\",\n    \"#X#\",\n    \"###\"\n  ],\n  \"key\": {\n    \"#\": \"%s\",\n    \"X\": \"minecraft:tnt\"\n  },\n  \"result\": {\n    \"count\": 1,\n    \"id\": \"%s\"\n  }\n}\n".formatted(dirtType, itemId);
    }

    public static String getLootTableJson(class_2960 blockId) {
        return "{\n  \"type\": \"minecraft:block\",\n  \"pools\": [\n    {\n      \"conditions\": [\n        {\n          \"condition\": \"minecraft:survives_explosion\"\n        }\n      ],\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"conditions\": [\n            {\n              \"block\": \"%s\",\n              \"condition\": \"minecraft:block_state_property\",\n              \"properties\": {\n                \"unstable\": \"false\"\n              }\n            }\n          ],\n          \"name\": \"%s\"\n        }\n      ],\n      \"rolls\": 1\n    }\n  ]\n}\n".formatted(blockId, blockId);
    }
}

