/*
 * Decompiled with CFR 0.152.
 */
package fourmisain.dirtnt;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fourmisain.dirtnt.DirTnt;
import fourmisain.dirtnt.client.DirtTntEntityRenderer;
import fourmisain.dirtnt.client.DirtTntSpriteRecipe;
import io.github.fourmisain.stitch.api.SpriteRecipe;
import io.github.fourmisain.stitch.api.Stitch;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5619;
import net.minecraft.class_790;

public class DirTntClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ModelLoadingPlugin.register(pluginContext -> {
            for (class_2960 dirtType : DirTnt.DIRT_TYPES) {
                class_2960 blockId = DirTnt.getDirtTntBlockId(dirtType);
                class_2960 blockModelId = blockId.method_45138("block/");
                pluginContext.registerBlockStateResolver((class_2248)DirTnt.BLOCK_MAP.get(dirtType), context -> {
                    JsonObject jsonElement = class_3518.method_15285((String)DirTntClient.getBlockStatesJson(blockModelId));
                    class_790 modelDefinition = (class_790)class_790.field_56928.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow(JsonParseException::new);
                    modelDefinition.comp_3813().ifPresent(modelVariants -> modelVariants.method_68508(context.block().method_9595(), () -> String.valueOf(blockId) + "/dirtnt", (arg_0, arg_1) -> ((BlockStateResolver.Context)context).setModel(arg_0, arg_1)));
                });
            }
        });
        for (class_2960 dirtType : DirTnt.DIRT_TYPES) {
            class_5619.method_32173(DirTnt.ENTITY_TYPE_MAP.get(dirtType), context -> new DirtTntEntityRenderer(dirtType, context));
            Stitch.registerRecipe((SpriteRecipe)new DirtTntSpriteRecipe(dirtType, "side"));
            Stitch.registerRecipe((SpriteRecipe)new DirtTntSpriteRecipe(dirtType, "top"));
            Stitch.registerRecipe((SpriteRecipe)new DirtTntSpriteRecipe(dirtType, "bottom"));
        }
    }

    public static String getCubeBottomTopBlockModelJson(class_2960 modelId) {
        return "{\n\t\"parent\": \"minecraft:block/cube_bottom_top\",\n\t\"textures\": {\n\t\t\"top\": \"%s_top\",\n\t\t\"bottom\": \"%s_bottom\",\n\t\t\"side\": \"%s_side\"\n\t}\n}\n".formatted(modelId, modelId, modelId);
    }

    public static String getBlockStatesJson(class_2960 modelId) {
        return "{\n  \"variants\": {\n    \"\": {\n      \"model\": \"%s\"\n    }\n  }\n}\n".formatted(modelId);
    }

    public static String getItemsJson(class_2960 modelId) {
        return "{\n  \"model\": {\n    \"type\": \"minecraft:model\",\n    \"model\": \"%s\"\n  }\n}\n".formatted(modelId);
    }
}

