/*
 * Decompiled with CFR 0.152.
 */
package fourmisain.dirtnt.client;

import fourmisain.dirtnt.DirTnt;
import io.github.fourmisain.stitch.api.SpriteRecipe;
import io.github.fourmisain.stitch.api.Stitch;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7677;
import net.minecraft.class_7764;
import net.minecraft.class_7771;

public class DirtTntSpriteRecipe
implements SpriteRecipe {
    private int w = 16;
    private int h = 16;
    private class_1011 image;
    private Optional<class_1079> animationResourceMetadata = Optional.empty();
    private List<class_7677.class_11554<?>> additionalMetadata;
    private final String side;
    private final class_2960 id;
    private final class_2960 dirtTexture;

    public DirtTntSpriteRecipe(class_2960 dirtType, String side) {
        this.side = side;
        class_2960 blockId = DirTnt.getDirtTntBlockId(dirtType);
        this.id = class_2960.method_60655((String)blockId.method_12836(), (String)("block/" + blockId.method_12832() + "_" + side));
        this.dirtTexture = class_2960.method_60655((String)dirtType.method_12836(), (String)("block/" + dirtType.method_12832()));
    }

    public class_2960 getSpriteId() {
        return this.id;
    }

    public Set<class_2960> getDependencies() {
        return Set.of(this.dirtTexture);
    }

    public void collectSprite(class_7764 sprite) {
        this.w = sprite.method_45807();
        this.h = sprite.method_45815();
        this.image = Stitch.getImage((class_7764)sprite);
        this.animationResourceMetadata = Stitch.getAnimationResourceMetadata((class_7764)sprite);
        this.additionalMetadata = Stitch.getAdditionalMetadata((class_7764)sprite);
    }

    public class_7771 generateSize() {
        return new class_7771(this.w, this.h);
    }

    public Optional<class_1079> generateAnimationResourceMetadata() {
        return this.animationResourceMetadata;
    }

    public List<class_7677.class_11554<?>> generateAdditionalMetadata() {
        return this.additionalMetadata;
    }

    public class_1011 generateImage(class_3300 resourceManager) {
        class_1011 templateTexture;
        class_2960 templateId = Stitch.getTextureResourcePath((class_2960)DirTnt.id("block/tnt_" + this.side + "_template"));
        Optional maybeResource = resourceManager.method_14486(templateId);
        if (maybeResource.isEmpty()) {
            DirTnt.LOGGER.error("texture template doesn't exist: {}", (Object)templateId);
            return null;
        }
        try (InputStream input = ((class_3298)maybeResource.get()).method_14482();){
            templateTexture = class_1011.method_4309((InputStream)input);
        }
        catch (IOException e) {
            DirTnt.LOGGER.error("couldn't load texture template {}", (Object)templateId, (Object)e);
            return null;
        }
        if (this.image == null) {
            this.image = Stitch.getMissingSprite((int)this.w, (int)this.h);
        }
        class_1011 image = new class_1011(this.image.method_4307(), this.image.method_4323(), false);
        image.method_4317(this.image);
        int xScale = this.w / 16;
        int yScale = this.h / 16;
        int xFrames = image.method_4307() / this.w;
        int yFrames = image.method_4323() / this.h;
        for (int j = 0; j < yFrames; ++j) {
            for (int i = 0; i < xFrames; ++i) {
                for (int y = 0; y < this.h; ++y) {
                    for (int x = 0; x < this.w; ++x) {
                        Stitch.blendColors((class_1011)image, (int)(i * this.w + x), (int)(j * this.h + y), (int)templateTexture.method_61940(x / xScale, y / yScale));
                    }
                }
            }
        }
        templateTexture.close();
        return image;
    }
}

