/*
 * Decompiled with CFR 0.152.
 */
package fourmisain.dirtnt.entity;

import fourmisain.dirtnt.DirTnt;
import fourmisain.dirtnt.Dirtable;
import fourmisain.dirtnt.block.DirtTntBlock;
import fourmisain.dirtnt.mixin.WorldAccessor;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1541;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_265;
import net.minecraft.class_2664;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class DirtTntEntity
extends class_1541 {
    public static final int RADIUS = 3;

    public DirtTntEntity(class_2960 dirtType, class_1299<? extends class_1541> entityType, class_1937 world) {
        super(entityType, world);
        ((Dirtable)((Object)this)).makeDirty(dirtType);
    }

    public DirtTntEntity(class_2960 dirtType, class_1937 world, double x, double y, double z) {
        this(dirtType, DirTnt.ENTITY_TYPE_MAP.get(dirtType), world);
        this.method_5814(x, y, z);
        double angle = world.field_9229.method_43058() * 2.0 * Math.PI;
        this.method_18800(-Math.sin(angle) * 0.02, 0.2, -Math.cos(angle) * 0.02);
        this.method_6967(80);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    public static void createDirtExplosion(class_2960 dirtType, class_1297 entity, class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        world.method_43275(entity, (class_6880)class_5712.field_28178, new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321()));
        class_2338 centerBlockPos = entity.method_24515();
        class_243 centerVec = entity.method_5829().method_1005();
        class_2338.class_2339 targetBlockPos = new class_2338.class_2339();
        Optional maybeDirtBlock = class_7923.field_41175.method_17966(dirtType);
        if (maybeDirtBlock.isEmpty()) {
            throw new AssertionError((Object)"Dirt TNT entity exists but block is not registered!");
        }
        class_2248 dirtBlock = (class_2248)maybeDirtBlock.get();
        int[] blockCount = new int[1];
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    targetBlockPos.method_10102(centerVec.field_1352 + (double)x, centerVec.field_1351 + (double)y, centerVec.field_1350 + (double)z);
                    class_243 targetVec = class_243.method_24953((class_2382)targetBlockPos);
                    if (!targetBlockPos.method_19771((class_2382)centerBlockPos, 4.0)) continue;
                    class_3959 context = new class_3959(centerVec, targetVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity);
                    class_1922.method_17744((class_243)context.method_17750(), (class_243)context.method_17747(), (Object)context, (ctx, pos) -> {
                        class_2680 state = world.method_8320(pos);
                        if (state.method_27852(dirtBlock)) {
                            return null;
                        }
                        DirtTntEntity.igniteDirtTnt(world, pos);
                        class_265 blockShape = ctx.method_17748(state, (class_1922)world, pos);
                        class_3965 hitResult = world.method_17745(ctx.method_17750(), ctx.method_17747(), pos, blockShape, state);
                        if (hitResult == null) {
                            if (state.method_45474()) {
                                world.method_8501(pos, dirtBlock.method_9564());
                                blockCount[0] = blockCount[0] + 1;
                            }
                            return null;
                        }
                        return state;
                    }, ctx -> null);
                }
            }
        }
        for (class_3222 player : ((class_3218)world).method_18456()) {
            if (!(player.method_5707(centerVec) < 4096.0)) continue;
            player.field_13987.method_14364((class_2596)new class_2664(centerVec, 4.0f, blockCount[0], Optional.empty(), (class_2394)class_2398.field_11236, (class_6880)class_3417.field_15152, WorldAccessor.getEXPLOSION_BLOCK_PARTICLES()));
        }
    }

    public static void igniteDirtTnt(class_1937 world, class_2338 pos) {
        class_2248 class_22482 = world.method_8320(pos).method_26204();
        if (class_22482 instanceof DirtTntBlock) {
            DirtTntBlock dirtTntBlock = (DirtTntBlock)class_22482;
            class_2960 dirtType = ((Dirtable)((Object)dirtTntBlock)).getDirtType();
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            DirtTntEntity tnt = new DirtTntEntity(dirtType, world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            int t = tnt.method_6969();
            tnt.method_6967(world.field_9229.method_43048(t / 4) + t / 8);
            world.method_8649((class_1297)tnt);
        }
    }
}

