/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import org.bukkit.entity.Player;

public final class Experience {
    public static long getExp(Player player) {
        return Experience.getExpFromLevel(player.getLevel()) + (long)Math.round((float)Experience.getExpToNext(player.getLevel()) * player.getExp());
    }

    public static long getExpFromLevel(int level) {
        if (level > 30) {
            return (long)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
        }
        if (level > 15) {
            return (long)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (long)level * (long)level + (long)(6 * level);
    }

    public static double getLevelFromExp(long exp) {
        int level = Experience.getIntLevelFromExp(exp);
        float remainder = (float)exp - (float)Experience.getExpFromLevel(level);
        float progress = remainder / (float)Experience.getExpToNext(level);
        return (double)level + (double)progress;
    }

    public static int getIntLevelFromExp(long exp) {
        if (exp > 1395L) {
            return (int)((Math.sqrt((double)(72L * exp) - 54215.0) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt((double)(40L * exp) - 7839.0) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt((double)exp + 9.0) - 3.0);
        }
        return 0;
    }

    public static int getExpToNext(int level) {
        if (level >= 30) {
            return level * 9 - 158;
        }
        if (level >= 15) {
            return level * 5 - 38;
        }
        return level * 2 + 7;
    }

    public static void changeExp(Player player, long exp) {
        long totalExp = Experience.getExp(player) + exp;
        if (totalExp < 0L) {
            totalExp = 0L;
        }
        double levelAndExp = Experience.getLevelFromExp(totalExp);
        int level = (int)levelAndExp;
        player.setLevel(level);
        player.setExp((float)(levelAndExp - (double)level));
    }

    public static boolean hasEnoughExp(Player player, long requiredExp) {
        return Experience.getExp(player) >= requiredExp;
    }

    public static long getExpToNextLevel(Player player) {
        int currentLevel = player.getLevel();
        long currentExp = Experience.getExp(player);
        long expForNextLevel = Experience.getExpFromLevel(currentLevel + 1);
        return expForNextLevel - currentExp;
    }

    public static long getExpNeededForLevel(Player player, int targetLevel) {
        if (targetLevel <= player.getLevel()) {
            return 0L;
        }
        long currentExp = Experience.getExp(player);
        long targetExp = Experience.getExpFromLevel(targetLevel);
        return targetExp - currentExp;
    }

    private Experience() {
    }
}

