/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import org.bukkit.entity.Player;

public final class ExperienceUtil {
    public static long getXPForLevels(int levels) {
        return Experience.getExpFromLevel(levels);
    }

    public static long getXPForLevelAdvancement(Player player, int levelsToAdvance) {
        int currentLevel = player.getLevel();
        int targetLevel = currentLevel + levelsToAdvance;
        long xpForTargetLevel = Experience.getExpFromLevel(targetLevel);
        long currentTotalXP = Experience.getExp(player);
        return xpForTargetLevel - currentTotalXP;
    }

    public static long getXPForLevelDeduction(Player player, int levelsToDeduct) {
        int currentLevel = player.getLevel();
        if (currentLevel < levelsToDeduct) {
            return Experience.getExp(player);
        }
        int targetLevel = currentLevel - levelsToDeduct;
        long currentTotalXP = Experience.getExp(player);
        long xpForTargetLevel = Experience.getExpFromLevel(targetLevel);
        return currentTotalXP - xpForTargetLevel;
    }

    public static void changePlayerXP(Player player, long xpChange) {
        Experience.changeExp(player, xpChange);
    }

    public static long getTotalXP(Player player) {
        return Experience.getExp(player);
    }

    public static boolean hasEnoughLevels(Player player, int levelsRequired) {
        return player.getLevel() >= levelsRequired;
    }

    public static long getExactXPForLevels(int levels) {
        return Experience.getExpFromLevel(levels);
    }

    public static int getExactLevelFromXP(long xp) {
        return Experience.getIntLevelFromExp(xp);
    }

    public static boolean hasEnoughXP(Player player, long requiredXP) {
        return Experience.hasEnoughExp(player, requiredXP);
    }

    public static long levelsToAbsoluteXP(int levels) {
        return Experience.getExpFromLevel(levels);
    }

    public static int absoluteXPToLevels(long xp) {
        return Experience.getIntLevelFromExp(xp);
    }

    private ExperienceUtil() {
    }
}

