/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.ExperienceUtil;
import com.falafel77.XPVault.XPVault;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class GiveXPCommand
implements CommandExecutor {
    private final XPVault plugin;

    public GiveXPCommand(XPVault plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 2) {
            sender.sendMessage(this.plugin.getMessage("givexp_usage"));
            return true;
        }
        Player targetPlayer = Bukkit.getPlayer((String)args[0]);
        if (targetPlayer == null) {
            sender.sendMessage(this.plugin.getMessage("player_not_found"));
            return true;
        }
        if (sender instanceof Player) {
            Player senderPlayer = (Player)sender;
            if (!this.plugin.getWorldManager().isEnabledInWorld(senderPlayer)) {
                sender.sendMessage(this.plugin.getMessage("world_not_enabled"));
                return true;
            }
        }
        if (!this.plugin.getWorldManager().isEnabledInWorld(targetPlayer)) {
            sender.sendMessage(this.plugin.getMessage("target_world_not_enabled").replace("%player%", targetPlayer.getName()));
            return true;
        }
        String arg = args[1].toLowerCase();
        long amount = 0L;
        boolean isLevel = false;
        int requestedLevels = 0;
        if (arg.endsWith("l")) {
            isLevel = true;
            try {
                requestedLevels = Integer.parseInt(arg.substring(0, arg.length() - 1));
                if (requestedLevels <= 0) {
                    sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                    return true;
                }
                amount = Experience.getExpFromLevel(requestedLevels);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number"));
                return true;
            }
        }
        try {
            amount = Long.parseLong(arg);
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessage("amount_must_be_number"));
            return true;
        }
        if (amount <= 0L) {
            sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
            return true;
        }
        if (sender instanceof Player) {
            Player playerSender = (Player)sender;
            long senderSavedXP = this.plugin.getXpManager().getPlayerSavedXP(playerSender);
            if (senderSavedXP < amount) {
                playerSender.sendMessage(this.plugin.getMessage("not_enough_xp_to_give").replace("%current_xp%", String.valueOf(senderSavedXP)));
                return true;
            }
            this.plugin.getXpManager().removePlayerSavedXP(playerSender, amount);
            if (isLevel) {
                int levelsEquivalent = Experience.getIntLevelFromExp(amount);
                playerSender.sendMessage(this.plugin.getMessage("xp_levels_given_sender").replace("%levels%", String.valueOf(levelsEquivalent)).replace("%amount%", String.valueOf(amount)).replace("%player%", targetPlayer.getName()).replace("%current_xp%", String.valueOf(ExperienceUtil.getTotalXP(playerSender))));
            } else {
                playerSender.sendMessage(this.plugin.getMessage("xp_given_sender").replace("%amount%", String.valueOf(amount)).replace("%player%", targetPlayer.getName()).replace("%current_xp%", String.valueOf(ExperienceUtil.getTotalXP(playerSender))));
            }
        } else {
            sender.sendMessage(this.plugin.getMessage("xp_given_console"));
        }
        this.plugin.getXpManager().addPlayerSavedXP(targetPlayer, amount);
        if (isLevel) {
            int levelsEquivalent = Experience.getIntLevelFromExp(amount);
            targetPlayer.sendMessage(this.plugin.getMessage("xp_levels_received").replace("%levels%", String.valueOf(levelsEquivalent)).replace("%amount%", String.valueOf(amount)).replace("%sender%", sender.getName()));
        } else {
            targetPlayer.sendMessage(this.plugin.getMessage("xp_received").replace("%amount%", String.valueOf(amount)).replace("%sender%", sender.getName()));
        }
        return true;
    }
}

