/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.ExperienceUtil;
import com.falafel77.XPVault.XPVault;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RetrieveXPCommand
implements CommandExecutor {
    private final XPVault plugin;

    public RetrieveXPCommand(XPVault plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("only_players_can_use_command"));
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getWorldManager().isEnabledInWorld(player)) {
            player.sendMessage(this.plugin.getMessage("world_not_enabled"));
            return true;
        }
        long savedXP = this.plugin.getXpManager().getPlayerSavedXP(player);
        if (args.length == 0) {
            if (savedXP <= 0L) {
                player.sendMessage(this.plugin.getMessage("no_saved_xp"));
                return true;
            }
            long currentXPBefore = ExperienceUtil.getTotalXP(player);
            ExperienceUtil.changePlayerXP(player, savedXP);
            long actualXPAfter = ExperienceUtil.getTotalXP(player);
            long actualXPRetrieved = actualXPAfter - currentXPBefore;
            this.plugin.getXpManager().setPlayerSavedXP(player, savedXP - actualXPRetrieved);
            player.sendMessage(this.plugin.getMessage("all_xp_retrieved").replace("%amount%", String.valueOf(actualXPRetrieved)));
            return true;
        }
        if (args.length == 1) {
            String arg = args[0].toLowerCase();
            long amountToRetrieve = 0L;
            boolean isLevel = false;
            if (arg.endsWith("l")) {
                isLevel = true;
                try {
                    int requestedLevels = Integer.parseInt(arg.substring(0, arg.length() - 1));
                    if (requestedLevels <= 0) {
                        sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                        return true;
                    }
                    int currentLevel = player.getLevel();
                    int targetLevel = currentLevel + requestedLevels;
                    long currentTotalXP = Experience.getExp(player);
                    long targetTotalXP = Experience.getExpFromLevel(targetLevel);
                    amountToRetrieve = targetTotalXP - currentTotalXP;
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("retrievexp_usage"));
                    return true;
                }
            }
            try {
                amountToRetrieve = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("retrievexp_usage"));
                return true;
            }
            if (amountToRetrieve <= 0L) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                return true;
            }
            if (savedXP < amountToRetrieve) {
                player.sendMessage(this.plugin.getMessage("not_enough_saved_xp").replace("%saved_xp%", String.valueOf(savedXP)).replace("%amount%", String.valueOf(amountToRetrieve)));
                return true;
            }
            long currentXPBefore = ExperienceUtil.getTotalXP(player);
            int currentLevelBefore = player.getLevel();
            ExperienceUtil.changePlayerXP(player, amountToRetrieve);
            long actualXPAfter = ExperienceUtil.getTotalXP(player);
            int currentLevelAfter = player.getLevel();
            long actualXPRetrieved = actualXPAfter - currentXPBefore;
            long newSavedXP = savedXP - actualXPRetrieved;
            this.plugin.getXpManager().setPlayerSavedXP(player, newSavedXP);
            if (isLevel) {
                int actualLevelsGained = currentLevelAfter - currentLevelBefore;
                player.sendMessage(this.plugin.getMessage("partial_xp_retrieved_levels").replace("%amount%", String.valueOf(actualXPRetrieved)).replace("%levels%", String.valueOf(actualLevelsGained)).replace("%remaining_xp%", String.valueOf(newSavedXP)));
            } else {
                player.sendMessage(this.plugin.getMessage("partial_xp_retrieved").replace("%amount%", String.valueOf(actualXPRetrieved)).replace("%remaining_xp%", String.valueOf(newSavedXP)));
            }
            return true;
        }
        sender.sendMessage(this.plugin.getMessage("retrievexp_usage"));
        return true;
    }
}

