/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.XPVault;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RetrieveXPTabCompleter
implements TabCompleter {
    private final XPVault plugin;

    public RetrieveXPTabCompleter(XPVault plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        long savedXP = this.plugin.getXpManager().getPlayerSavedXP(player);
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (savedXP > 0L) {
                int savedLevels;
                suggestions.add(String.valueOf(savedXP));
                if (savedXP >= 10L) {
                    suggestions.add("10");
                }
                if (savedXP >= 100L) {
                    suggestions.add("100");
                }
                if (savedXP >= 1000L) {
                    suggestions.add("1000");
                }
                if (savedXP >= 10000L) {
                    suggestions.add("10000");
                }
                if ((savedLevels = Experience.getIntLevelFromExp(savedXP)) > 0) {
                    suggestions.add(savedLevels + "l");
                    for (int i = 1; i <= Math.min(savedLevels, 10); ++i) {
                        suggestions.add(i + "l");
                    }
                }
            }
            String input = args[0];
            ArrayList<String> dynamicSuggestions = new ArrayList<String>(suggestions);
            try {
                int num = Integer.parseInt(input);
                dynamicSuggestions.clear();
                dynamicSuggestions.add(num + "l");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return dynamicSuggestions.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

