/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.XPVault;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLiteManager {
    private final XPVault plugin;
    private Connection connection;
    private String databasePath;

    public SQLiteManager(XPVault plugin) {
        this.plugin = plugin;
        this.databasePath = plugin.getDataFolder().getAbsolutePath() + File.separator + "xpvault.db";
    }

    public Connection getConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                return this.connection;
            }
            this.reconnect();
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("Error checking connection: " + ex.getMessage());
            this.reconnect();
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            SQLiteManager sQLiteManager = this;
            synchronized (sQLiteManager) {
                if (this.connection != null && !this.connection.isClosed()) {
                    return;
                }
                File dataFolder = new File(this.plugin.getDataFolder(), "xpvault.db");
                if (!dataFolder.exists()) {
                    this.plugin.getDataFolder().mkdirs();
                    dataFolder.createNewFile();
                }
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databasePath);
                try (Statement stmt = this.connection.createStatement();){
                    stmt.execute("PRAGMA journal_mode=WAL");
                    stmt.execute("PRAGMA synchronous=NORMAL");
                    stmt.execute("PRAGMA temp_store=MEMORY");
                    stmt.execute("PRAGMA mmap_size=30000000000");
                }
                this.plugin.getLogger().info("SQLite connection established.");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("SQLite connection error: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            this.plugin.getLogger().severe("SQLite JDBC driver not found: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Unknown error establishing SQLite connection: " + ex.getMessage());
        }
        this.initializeDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect() {
        try {
            SQLiteManager sQLiteManager = this;
            synchronized (sQLiteManager) {
                if (this.connection != null && !this.connection.isClosed()) {
                    return;
                }
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databasePath);
                try (Statement stmt = this.connection.createStatement();){
                    stmt.execute("PRAGMA journal_mode=WAL");
                    stmt.execute("PRAGMA synchronous=NORMAL");
                    stmt.execute("PRAGMA temp_store=MEMORY");
                    stmt.execute("PRAGMA mmap_size=30000000000");
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("SQLite reconnection error: " + ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            this.plugin.getLogger().severe("SQLite JDBC driver not found: " + ex.getMessage());
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Unknown error reconnecting SQLite: " + ex.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.plugin.getLogger().info("SQLite connection closed.");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("SQLite close error: " + ex.getMessage());
        }
    }

    private void initializeDatabase() {
        try (Statement statement = this.connection.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS player_xp (";
            sql = sql + "uuid VARCHAR(36) PRIMARY KEY,";
            sql = sql + "xp INTEGER NOT NULL DEFAULT 0";
            sql = sql + ");";
            statement.execute(sql);
            statement.execute("CREATE INDEX IF NOT EXISTS idx_uuid ON player_xp(uuid);");
            this.plugin.getLogger().info("SQLite table 'player_xp' checked/created.");
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("SQLite table creation error: " + ex.getMessage());
        }
    }
}

