/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.ExperienceUtil;
import com.falafel77.XPVault.XPVault;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SaveXPCommand
implements CommandExecutor {
    private final XPVault plugin;

    public SaveXPCommand(XPVault plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("only_players_can_use_command"));
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.getWorldManager().isEnabledInWorld(player)) {
            player.sendMessage(this.plugin.getMessage("world_not_enabled"));
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage(this.plugin.getMessage("savexp_usage"));
            return true;
        }
        String arg = args[0].toLowerCase();
        long amountToSave = 0L;
        boolean isLevel = false;
        long currentXP = ExperienceUtil.getTotalXP(player);
        if (arg.endsWith("l")) {
            isLevel = true;
            try {
                int levelsToSave = Integer.parseInt(arg.substring(0, arg.length() - 1));
                if (levelsToSave <= 0) {
                    sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                    return true;
                }
                if (!ExperienceUtil.hasEnoughLevels(player, levelsToSave)) {
                    player.sendMessage(this.plugin.getMessage("not_enough_xp_saving_what_you_have").replace("%current_xp%", String.valueOf(currentXP)));
                    amountToSave = currentXP;
                }
                amountToSave = ExperienceUtil.getXPForLevelDeduction(player, levelsToSave);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("savexp_usage"));
                return true;
            }
        } else {
            try {
                amountToSave = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("savexp_usage"));
                return true;
            }
        }
        if (amountToSave <= 0L) {
            sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
            return true;
        }
        if (!isLevel && currentXP < amountToSave) {
            player.sendMessage(this.plugin.getMessage("not_enough_xp_saving_what_you_have").replace("%current_xp%", String.valueOf(currentXP)));
            amountToSave = currentXP;
        }
        if (amountToSave <= 0L) {
            sender.sendMessage("\u0644\u064a\u0633 \u0644\u062f\u064a\u0643 XP \u0644\u0644\u062d\u0641\u0638!");
            return true;
        }
        long xpBeforeSaving = currentXP;
        ExperienceUtil.changePlayerXP(player, -amountToSave);
        long actualXPAfter = ExperienceUtil.getTotalXP(player);
        long actualXPSaved = xpBeforeSaving - actualXPAfter;
        long savedXP = this.plugin.getXpManager().getPlayerSavedXP(player);
        this.plugin.getXpManager().setPlayerSavedXP(player, savedXP + actualXPSaved);
        if (isLevel) {
            int levelBefore = Experience.getIntLevelFromExp(xpBeforeSaving);
            int levelAfter = player.getLevel();
            int levelsSaved = levelBefore - levelAfter;
            player.sendMessage(this.plugin.getMessage("xp_levels_saved").replace("%levels%", String.valueOf(levelsSaved)).replace("%amount%", String.valueOf(actualXPSaved)).replace("%current_xp%", String.valueOf(actualXPAfter)));
        } else {
            player.sendMessage(this.plugin.getMessage("xp_saved").replace("%amount%", String.valueOf(actualXPSaved)).replace("%current_xp%", String.valueOf(actualXPAfter)));
        }
        return true;
    }
}

