/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.ExperienceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SaveXPTabCompleter
implements TabCompleter {
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        long currentXP = ExperienceUtil.getTotalXP(player);
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            suggestions.add("10");
            suggestions.add("100");
            suggestions.add("1000");
            suggestions.add("10000");
            int currentLevel = player.getLevel();
            int maxLevelsToSuggest = Math.min(currentLevel, 10);
            for (int i = 1; i <= maxLevelsToSuggest; ++i) {
                if (!ExperienceUtil.hasEnoughLevels(player, i)) continue;
                suggestions.add(i + "l");
            }
            if (currentXP > 0L) {
                suggestions.add(String.valueOf(currentXP));
            }
            if (currentLevel > 0) {
                suggestions.add(currentLevel + "l");
            }
            String input = args[0];
            ArrayList<String> dynamicSuggestions = new ArrayList<String>(suggestions);
            try {
                int num = Integer.parseInt(input);
                dynamicSuggestions.clear();
                dynamicSuggestions.add(num + "l");
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return dynamicSuggestions.stream().filter(s -> s.toLowerCase().startsWith(input.toLowerCase())).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

