/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.XPVault;
import java.util.List;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class WorldManager {
    private final XPVault plugin;
    private List<String> enabledWorlds;

    public WorldManager(XPVault plugin) {
        this.plugin = plugin;
        this.loadEnabledWorlds();
    }

    public void loadEnabledWorlds() {
        this.enabledWorlds = this.plugin.getConfig().getStringList("enabled-worlds");
        if (this.enabledWorlds.isEmpty()) {
            this.plugin.getLogger().warning("No worlds configured in enabled-worlds list. XPVault will be disabled in all worlds!");
        } else {
            this.plugin.getLogger().info("XPVault enabled in worlds: " + String.join((CharSequence)", ", this.enabledWorlds));
        }
    }

    public boolean isEnabledInWorld(Player player) {
        if (this.enabledWorlds.isEmpty()) {
            return false;
        }
        World world = player.getWorld();
        return this.enabledWorlds.contains(world.getName());
    }

    public boolean isEnabledInWorld(String worldName) {
        if (this.enabledWorlds.isEmpty()) {
            return false;
        }
        return this.enabledWorlds.contains(worldName);
    }

    public List<String> getEnabledWorlds() {
        return this.enabledWorlds;
    }

    public void reload() {
        this.loadEnabledWorlds();
    }
}

