/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.SQLiteManager;
import com.falafel77.XPVault.XPVault;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class XPManager {
    private final XPVault plugin;
    private final SQLiteManager sqLiteManager;
    private final Map<UUID, Long> xpCache = new HashMap<UUID, Long>();

    public XPManager(XPVault plugin, SQLiteManager sqLiteManager) {
        this.plugin = plugin;
        this.sqLiteManager = sqLiteManager;
    }

    public long getPlayerSavedXP(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.xpCache.containsKey(playerUUID)) {
            return this.xpCache.get(playerUUID);
        }
        long savedXP = 0L;
        try (Connection conn = this.sqLiteManager.getConnection();
             PreparedStatement ps = conn.prepareStatement("SELECT xp FROM player_xp WHERE uuid = ?");){
            ps.setString(1, playerUUID.toString());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                savedXP = rs.getLong("xp");
            }
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("Error getting player XP from SQLite: " + ex.getMessage());
        }
        this.xpCache.put(playerUUID, savedXP);
        return savedXP;
    }

    public CompletableFuture<Long> getPlayerSavedXPAsync(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.xpCache.containsKey(playerUUID)) {
            return CompletableFuture.completedFuture(this.xpCache.get(playerUUID));
        }
        return CompletableFuture.supplyAsync(() -> {
            long savedXP = 0L;
            try (Connection conn = this.sqLiteManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement("SELECT xp FROM player_xp WHERE uuid = ?");){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    savedXP = rs.getLong("xp");
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error getting player XP from SQLite: " + ex.getMessage());
            }
            long finalSavedXP = savedXP;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.xpCache.put(playerUUID, finalSavedXP));
            return savedXP;
        });
    }

    public void setPlayerSavedXP(Player player, long xp) {
        if (xp < 0L) {
            xp = 0L;
        }
        UUID playerUUID = player.getUniqueId();
        long finalXP = xp;
        this.xpCache.put(playerUUID, finalXP);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.sqLiteManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement("INSERT OR REPLACE INTO player_xp (uuid, xp) VALUES (?, ?)");){
                ps.setString(1, playerUUID.toString());
                ps.setLong(2, finalXP);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error setting player XP in SQLite: " + ex.getMessage());
            }
        });
    }

    public void addPlayerSavedXP(Player player, long amount) {
        long newXP;
        if (amount <= 0L) {
            return;
        }
        long currentXP = this.getPlayerSavedXP(player);
        if (currentXP > Long.MAX_VALUE - amount) {
            newXP = Long.MAX_VALUE;
            this.plugin.getLogger().warning("XP overflow prevented for player " + player.getName());
        } else {
            newXP = currentXP + amount;
        }
        this.setPlayerSavedXP(player, newXP);
    }

    public void removePlayerSavedXP(Player player, long amount) {
        if (amount <= 0L) {
            return;
        }
        long currentXP = this.getPlayerSavedXP(player);
        long newXP = Math.max(0L, currentXP - amount);
        this.setPlayerSavedXP(player, newXP);
    }

    public void clearAllSavedXP() {
        this.xpCache.clear();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.sqLiteManager.getConnection();
                 Statement statement = conn.createStatement();){
                statement.executeUpdate("DELETE FROM player_xp");
                this.plugin.getLogger().info("All player XP data cleared from SQLite.");
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error clearing all player XP data from SQLite: " + ex.getMessage());
            }
        });
    }

    public void loadPlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            long savedXP = 0L;
            try (Connection conn = this.sqLiteManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement("SELECT xp FROM player_xp WHERE uuid = ?");){
                ps.setString(1, playerUUID.toString());
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    savedXP = rs.getLong("xp");
                }
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error loading player data: " + ex.getMessage());
            }
            long finalSavedXP = savedXP;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.xpCache.put(playerUUID, finalSavedXP));
        });
    }

    public void unloadPlayerData(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (!this.xpCache.containsKey(playerUUID)) {
            return;
        }
        long xp = this.xpCache.get(playerUUID);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection conn = this.sqLiteManager.getConnection();
                 PreparedStatement ps = conn.prepareStatement("INSERT OR REPLACE INTO player_xp (uuid, xp) VALUES (?, ?)");){
                ps.setString(1, playerUUID.toString());
                ps.setLong(2, xp);
                ps.executeUpdate();
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error saving player data on quit: " + ex.getMessage());
            }
        });
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.xpCache.remove(playerUUID), 20L);
    }

    public void clearCache(UUID playerUUID) {
        this.xpCache.remove(playerUUID);
    }

    public void clearAllCache() {
        this.xpCache.clear();
    }
}

