/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.AdminXPCommand;
import com.falafel77.XPVault.CheckXPCommand;
import com.falafel77.XPVault.CheckXPCompleter;
import com.falafel77.XPVault.GiveXPCommand;
import com.falafel77.XPVault.GiveXPTabCompleter;
import com.falafel77.XPVault.ReloadCommand;
import com.falafel77.XPVault.ReloadTabCompleter;
import com.falafel77.XPVault.RetrieveXPCommand;
import com.falafel77.XPVault.RetrieveXPTabCompleter;
import com.falafel77.XPVault.SQLiteManager;
import com.falafel77.XPVault.SaveXPCommand;
import com.falafel77.XPVault.SaveXPTabCompleter;
import com.falafel77.XPVault.WorldManager;
import com.falafel77.XPVault.XPManager;
import com.falafel77.XPVault.XPSavedPlaceholder;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Scanner;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class XPVault
extends JavaPlugin
implements Listener {
    private XPManager xpManager;
    private SQLiteManager sqLiteManager;
    private WorldManager worldManager;
    private FileConfiguration messagesConfig;
    private String latestVersion = null;
    private boolean updateAvailable = false;

    public void onEnable() {
        this.saveDefaultConfig();
        this.createMessagesConfig();
        if (this.messagesConfig != null) {
            this.getLogger().info(this.getMessage("plugin_enabled"));
        } else {
            this.getLogger().warning("Failed to load messages.yml. Plugin messages may not work correctly.");
        }
        this.sqLiteManager = new SQLiteManager(this);
        this.sqLiteManager.load();
        this.xpManager = new XPManager(this, this.sqLiteManager);
        this.worldManager = new WorldManager(this);
        this.registerCommands();
        this.registerEvents();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new XPSavedPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI hooked successfully!");
        }
        this.checkForUpdates();
    }

    private void registerCommands() {
        this.getCommand("savexp").setExecutor((CommandExecutor)new SaveXPCommand(this));
        this.getCommand("savexp").setTabCompleter((TabCompleter)new SaveXPTabCompleter());
        this.getCommand("givexp").setExecutor((CommandExecutor)new GiveXPCommand(this));
        this.getCommand("givexp").setTabCompleter((TabCompleter)new GiveXPTabCompleter());
        this.getCommand("retrievexp").setExecutor((CommandExecutor)new RetrieveXPCommand(this));
        this.getCommand("retrievexp").setTabCompleter((TabCompleter)new RetrieveXPTabCompleter(this));
        AdminXPCommand adminXPCommand = new AdminXPCommand(this);
        this.getCommand("adminxp").setExecutor((CommandExecutor)adminXPCommand);
        this.getCommand("adminxp").setTabCompleter((TabCompleter)adminXPCommand);
        this.getCommand("checkxp").setExecutor((CommandExecutor)new CheckXPCommand(this.xpManager, this));
        this.getCommand("checkxp").setTabCompleter((TabCompleter)new CheckXPCompleter());
        this.getCommand("xpvaultreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getCommand("xpvaultreload").setTabCompleter((TabCompleter)new ReloadTabCompleter());
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.xpManager.loadPlayerData(event.getPlayer());
        if (this.updateAvailable && event.getPlayer().isOp()) {
            event.getPlayer().sendMessage(ChatColor.YELLOW + "XPVault: A new update is available! Current version: " + this.getDescription().getVersion() + ", Latest version: " + this.latestVersion);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.xpManager.unloadPlayerData(event.getPlayer());
    }

    private void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            String versionUrl = "https://api.github.com/repos/falafel77/XPVault/releases/latest";
            try {
                URI uri = URI.create(versionUrl);
                URL url = uri.toURL();
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(5000);
                conn.setReadTimeout(5000);
                conn.setRequestProperty("User-Agent", "XPVault-Plugin");
                int status = conn.getResponseCode();
                if (status == 200) {
                    InputStream is = conn.getInputStream();
                    Scanner scanner = new Scanner(is).useDelimiter("\\A");
                    String response = scanner.hasNext() ? scanner.next() : "";
                    scanner.close();
                    is.close();
                    int tagIndex = response.indexOf("\"tag_name\":");
                    if (tagIndex != -1) {
                        int start = response.indexOf(34, tagIndex + 11) + 1;
                        int end = response.indexOf(34, start);
                        this.latestVersion = response.substring(start, end);
                        String currentVersion = this.getDescription().getVersion();
                        if (!this.latestVersion.equalsIgnoreCase(currentVersion)) {
                            this.updateAvailable = true;
                            this.getLogger().warning("A new update is available! Current version: " + currentVersion + ", Latest version: " + this.latestVersion);
                        }
                    }
                }
                conn.disconnect();
            }
            catch (Exception e) {
                this.getLogger().info("Unable to check for updates: " + e.getMessage());
            }
        });
    }

    public void onDisable() {
        if (this.messagesConfig != null) {
            this.getLogger().info(this.getMessage("plugin_disabled"));
        }
        if (this.sqLiteManager != null) {
            this.sqLiteManager.close();
        }
    }

    public XPManager getXpManager() {
        return this.xpManager;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public void createMessagesConfig() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        InputStream defaultStream = this.getResource("messages.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.messagesConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        return ChatColor.RED + "Message not found: " + path;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public SQLiteManager getSqLiteManager() {
        return this.sqLiteManager;
    }
}

