/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.ExperienceUtil;
import com.falafel77.XPVault.XPVault;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RetrieveXPCommand
implements CommandExecutor {
    private final XPVault plugin;

    public RetrieveXPCommand(XPVault plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("only_players_can_use_command"));
            return true;
        }
        Player player = (Player)sender;
        long savedXP = this.plugin.getXpManager().getPlayerSavedXP(player);
        if (args.length == 0) {
            if (savedXP <= 0L) {
                player.sendMessage(this.plugin.getMessage("no_saved_xp"));
                return true;
            }
            long currentXPBeforeAll = ExperienceUtil.getTotalXP(player);
            ExperienceUtil.changePlayerXP(player, savedXP);
            long actualXPAfterAll = ExperienceUtil.getTotalXP(player);
            long actualXPRetrievedAll = actualXPAfterAll - currentXPBeforeAll;
            this.plugin.getXpManager().getCustomConfig().set(player.getUniqueId().toString() + ".xp", (Object)(savedXP - actualXPRetrievedAll));
            this.plugin.getXpManager().saveCustomConfig();
            player.sendMessage(this.plugin.getMessage("all_xp_retrieved").replace("%amount%", String.valueOf(actualXPRetrievedAll)));
            return true;
        }
        if (args.length == 1) {
            String arg = args[0].toLowerCase();
            long amountToRetrieve = 0L;
            boolean isLevel = false;
            if (arg.endsWith("l")) {
                isLevel = true;
                try {
                    int levelsToRetrieve = Integer.parseInt(arg.substring(0, arg.length() - 1));
                    if (levelsToRetrieve <= 0) {
                        sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                        return true;
                    }
                    amountToRetrieve = ExperienceUtil.getXPForLevelAdvancement(player, levelsToRetrieve);
                }
                catch (NumberFormatException e) {
                    sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("retrievexp_usage"));
                    return true;
                }
            }
            try {
                amountToRetrieve = Long.parseLong(arg);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number") + ". " + this.plugin.getMessage("retrievexp_usage"));
                return true;
            }
            if (amountToRetrieve <= 0L) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_positive"));
                return true;
            }
            if (savedXP < amountToRetrieve) {
                player.sendMessage(this.plugin.getMessage("not_enough_saved_xp").replace("%saved_xp%", String.valueOf(savedXP)).replace("%amount%", String.valueOf(amountToRetrieve)));
                return true;
            }
            long currentXPBeforePartial = ExperienceUtil.getTotalXP(player);
            ExperienceUtil.changePlayerXP(player, amountToRetrieve);
            long actualXPAfterPartial = ExperienceUtil.getTotalXP(player);
            long actualXPRetrievedPartial = actualXPAfterPartial - currentXPBeforePartial;
            long newSavedXPPartial = savedXP - actualXPRetrievedPartial;
            this.plugin.getXpManager().getCustomConfig().set(player.getUniqueId().toString() + ".xp", (Object)newSavedXPPartial);
            this.plugin.getXpManager().saveCustomConfig();
            if (isLevel) {
                int levelsEquivalent = Experience.getIntLevelFromExp(actualXPRetrievedPartial);
                player.sendMessage(this.plugin.getMessage("partial_xp_retrieved_levels").replace("%amount%", String.valueOf(actualXPRetrievedPartial)).replace("%levels%", String.valueOf(levelsEquivalent)).replace("%remaining_xp%", String.valueOf(newSavedXPPartial)));
            } else {
                player.sendMessage(this.plugin.getMessage("partial_xp_retrieved").replace("%amount%", String.valueOf(actualXPRetrievedPartial)).replace("%remaining_xp%", String.valueOf(newSavedXPPartial)));
            }
            return true;
        }
        sender.sendMessage(this.plugin.getMessage("retrievexp_usage"));
        return true;
    }
}

