/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.AdminXPCommand;
import com.falafel77.XPVault.CheckXPCommand;
import com.falafel77.XPVault.GiveXPCommand;
import com.falafel77.XPVault.GiveXPTabCompleter;
import com.falafel77.XPVault.RetrieveXPCommand;
import com.falafel77.XPVault.RetrieveXPTabCompleter;
import com.falafel77.XPVault.SaveXPCommand;
import com.falafel77.XPVault.SaveXPTabCompleter;
import com.falafel77.XPVault.XPManager;
import com.falafel77.XPVault.XPSavedPlaceholder;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class XPVault
extends JavaPlugin {
    private XPManager xpManager;
    private FileConfiguration messagesConfig;

    public void onEnable() {
        this.createMessagesConfig();
        if (this.messagesConfig != null) {
            this.getLogger().info(this.getMessage("plugin_enabled"));
        } else {
            this.getLogger().warning("Failed to load messages.yml. Plugin messages may not work correctly.");
        }
        this.xpManager = new XPManager(this);
        this.registerCommands();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new XPSavedPlaceholder(this).register();
        }
    }

    private void registerCommands() {
        this.getCommand("savexp").setExecutor((CommandExecutor)new SaveXPCommand(this));
        this.getCommand("savexp").setTabCompleter((TabCompleter)new SaveXPTabCompleter());
        this.getCommand("givexp").setExecutor((CommandExecutor)new GiveXPCommand(this));
        this.getCommand("givexp").setTabCompleter((TabCompleter)new GiveXPTabCompleter());
        this.getCommand("retrievexp").setExecutor((CommandExecutor)new RetrieveXPCommand(this));
        this.getCommand("retrievexp").setTabCompleter((TabCompleter)new RetrieveXPTabCompleter(this));
        AdminXPCommand adminXPCommand = new AdminXPCommand(this);
        this.getCommand("adminxp").setExecutor((CommandExecutor)adminXPCommand);
        this.getCommand("adminxp").setTabCompleter((TabCompleter)adminXPCommand);
        this.getCommand("checkxp").setExecutor((CommandExecutor)new CheckXPCommand(this.xpManager, this));
    }

    public void onDisable() {
        this.unregisterCommands();
        if (this.messagesConfig != null) {
            this.getLogger().info(this.getMessage("plugin_disabled"));
        } else {
            this.getLogger().warning("messages.yml was not loaded, cannot display plugin_disabled message.");
        }
    }

    private void unregisterCommands() {
        try {
            PluginManager pluginManager = Bukkit.getPluginManager();
            Field commandMapField = pluginManager.getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            CommandMap commandMap = (CommandMap)commandMapField.get(pluginManager);
            Field knownCommandsField = commandMap.getClass().getDeclaredField("knownCommands");
            knownCommandsField.setAccessible(true);
            Map knownCommands = (Map)knownCommandsField.get(commandMap);
            knownCommands.remove("savexp");
            knownCommands.remove("givexp");
            knownCommands.remove("retrievexp");
            knownCommands.remove("adminxp");
            knownCommands.remove("checkxp");
            knownCommands.remove("sxp");
            knownCommands.remove("gxp");
            knownCommands.remove("rxp");
            knownCommands.remove("cxp");
            Field aliasesField = commandMap.getClass().getDeclaredField("aliases");
            aliasesField.setAccessible(true);
            Map aliases = (Map)aliasesField.get(commandMap);
            aliases.remove("sxp");
            aliases.remove("gxp");
            aliases.remove("rxp");
            aliases.remove("cxp");
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to unregister commands: " + e.getMessage());
        }
    }

    public XPManager getXpManager() {
        return this.xpManager;
    }

    private void createMessagesConfig() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            messagesFile.getParentFile().mkdirs();
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
        InputStream defaultStream = this.getResource("messages.yml");
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.messagesConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public String getMessage(String path) {
        String message = this.messagesConfig.getString(path);
        if (message != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        return null;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }
}

