/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.XPVault;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class AdminXPCommand
implements CommandExecutor,
TabCompleter {
    private final XPVault plugin;

    public AdminXPCommand(XPVault plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("xpvault.admin")) {
            sender.sendMessage(this.plugin.getMessage("no_permission"));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(this.plugin.getMessage("adminxp_usage"));
            return true;
        }
        String subCommand = args[0].toLowerCase();
        if (subCommand.equals("resetall")) {
            if (args.length == 1) {
                this.plugin.getXpManager().getCustomConfig().set("", null);
                this.plugin.getXpManager().saveCustomConfig();
                sender.sendMessage(this.plugin.getMessage("adminxp_reset_all_success"));
                return true;
            }
            sender.sendMessage(this.plugin.getMessage("adminxp_reset_all_usage"));
            return true;
        }
        if (subCommand.equals("set") || subCommand.equals("add") || subCommand.equals("remove")) {
            long currentSavedXP;
            long amount;
            if (args.length < 3) {
                sender.sendMessage(this.plugin.getMessage("adminxp_player_usage"));
                return true;
            }
            Player targetPlayer = Bukkit.getPlayer((String)args[1]);
            if (targetPlayer == null) {
                sender.sendMessage(this.plugin.getMessage("player_not_found"));
                return true;
            }
            try {
                amount = Long.parseLong(args[2]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage(this.plugin.getMessage("amount_must_be_number"));
                return true;
            }
            long newXP = currentSavedXP = this.plugin.getXpManager().getPlayerSavedXP(targetPlayer);
            if (subCommand.equals("set")) {
                newXP = amount;
            } else if (subCommand.equals("add")) {
                newXP += amount;
            } else if (subCommand.equals("remove")) {
                newXP -= amount;
            }
            if (newXP < 0L) {
                newXP = 0L;
            }
            this.plugin.getXpManager().getCustomConfig().set(targetPlayer.getUniqueId().toString() + ".xp", (Object)newXP);
            this.plugin.getXpManager().saveCustomConfig();
            sender.sendMessage(this.plugin.getMessage("adminxp_player_success").replace("%player%", targetPlayer.getName()).replace("%action%", subCommand).replace("%amount%", String.valueOf(amount)).replace("%new_xp%", String.valueOf(newXP)));
            return true;
        }
        sender.sendMessage(this.plugin.getMessage("adminxp_usage"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block6: {
            String subCommand;
            block7: {
                block5: {
                    if (!sender.hasPermission("xpvault.admin")) {
                        return new ArrayList<String>();
                    }
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block5;
                    List<String> subCommands = Arrays.asList("set", "add", "remove", "resetall");
                    String input = args[0].toLowerCase();
                    for (String subCommand2 : subCommands) {
                        if (!subCommand2.startsWith(input)) continue;
                        completions.add(subCommand2);
                    }
                    break block6;
                }
                if (args.length != 2) break block7;
                String subCommand3 = args[0].toLowerCase();
                if (!subCommand3.equals("set") && !subCommand3.equals("add") && !subCommand3.equals("remove")) break block6;
                String input = args[1].toLowerCase();
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().startsWith(input)) continue;
                    completions.add(player.getName());
                }
                break block6;
            }
            if (args.length == 3 && ((subCommand = args[0].toLowerCase()).equals("set") || subCommand.equals("add") || subCommand.equals("remove"))) {
                List<String> amounts = Arrays.asList("100", "500", "1000", "5000", "10000");
                String input = args[2].toLowerCase();
                for (String amount : amounts) {
                    if (!amount.startsWith(input)) continue;
                    completions.add(amount);
                }
            }
        }
        return completions;
    }
}

