/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import org.bukkit.entity.Player;

public class Experience {
    public static long getExp(Player player) {
        return Math.round((float)Experience.getExpFromLevel(player.getLevel()) + player.getExp() * (float)Experience.getExpToNext(player.getLevel()));
    }

    public static long getExpFromLevel(int level) {
        if (level <= 0) {
            return 0L;
        }
        if (level <= 15) {
            return level * level + 6 * level;
        }
        if (level <= 30) {
            return (long)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (long)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }

    public static int getExpToNext(int level) {
        if (level <= 15) {
            return 2 * level + 7;
        }
        if (level <= 30) {
            return 5 * level - 38;
        }
        return 9 * level - 158;
    }

    public static int getIntLevelFromExp(long exp) {
        if (exp <= 0L) {
            return 0;
        }
        int level = 0;
        while (Experience.getExpFromLevel(level + 1) <= exp) {
            ++level;
        }
        return level;
    }

    public static void changeExp(Player player, int exp) {
        long currentExp = Experience.getExp(player);
        long newExp = currentExp + (long)exp;
        if (newExp < 0L) {
            newExp = 0L;
        }
        Experience.setExp(player, newExp);
    }

    public static void setExp(Player player, long exp) {
        long expToNext;
        if (exp < 0L) {
            exp = 0L;
        }
        int level = Experience.getIntLevelFromExp(exp);
        long expForLevel = Experience.getExpFromLevel(level);
        float progress = 0.0f;
        if (level < Integer.MAX_VALUE && (expToNext = (long)Experience.getExpToNext(level)) > 0L) {
            progress = (float)(exp - expForLevel) / (float)expToNext;
        }
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        player.setLevel(level);
        player.setExp(progress);
    }

    public static double getLevelFromExp(long exp) {
        int level = Experience.getIntLevelFromExp(exp);
        long expForLevel = Experience.getExpFromLevel(level);
        long expToNext = Experience.getExpToNext(level);
        if (expToNext <= 0L) {
            return level;
        }
        double progress = (double)(exp - expForLevel) / (double)expToNext;
        return (double)level + Math.min(progress, 1.0);
    }

    public static boolean hasEnoughExp(Player player, long requiredExp) {
        return Experience.getExp(player) >= requiredExp;
    }

    public static long getExpToNextLevel(Player player) {
        int currentLevel = player.getLevel();
        long currentExp = Experience.getExp(player);
        long expForNextLevel = Experience.getExpFromLevel(currentLevel + 1);
        return expForNextLevel - currentExp;
    }

    public static long getExpNeededForLevel(Player player, int targetLevel) {
        if (targetLevel <= player.getLevel()) {
            return 0L;
        }
        long currentExp = Experience.getExp(player);
        long targetExp = Experience.getExpFromLevel(targetLevel);
        return targetExp - currentExp;
    }
}

