/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import org.bukkit.entity.Player;

public final class ExperienceUtil {
    public static long getXPForLevels(int levels) {
        return Experience.getExpFromLevel(levels);
    }

    public static long getXPForLevelAdvancement(Player player, int levelsToAdvance) {
        int currentLevel = player.getLevel();
        long xpForHigherLevel = Experience.getExpFromLevel(currentLevel + levelsToAdvance);
        long xpForCurrentLevel = Experience.getExpFromLevel(currentLevel);
        long partialXP = Math.round((float)Experience.getExpToNext(currentLevel) * player.getExp());
        return xpForHigherLevel - xpForCurrentLevel + partialXP;
    }

    public static long getXPForLevelDeduction(Player player, int levelsToDeduct) {
        int currentLevel = player.getLevel();
        if (currentLevel < levelsToDeduct) {
            return Experience.getExp(player);
        }
        long xpForCurrentLevel = Experience.getExpFromLevel(currentLevel);
        long xpForLowerLevel = Experience.getExpFromLevel(currentLevel - levelsToDeduct);
        long levelXP = xpForCurrentLevel - xpForLowerLevel;
        long partialXP = Math.round((float)Experience.getExpToNext(currentLevel) * player.getExp());
        return levelXP + partialXP;
    }

    public static void changePlayerXP(Player player, long xpChange) {
        int xpChangeInt = (int)Math.max(Integer.MIN_VALUE, Math.min(Integer.MAX_VALUE, xpChange));
        Experience.changeExp(player, xpChangeInt);
    }

    public static long getTotalXP(Player player) {
        return Experience.getExp(player);
    }

    public static boolean hasEnoughLevels(Player player, int levelsRequired) {
        return player.getLevel() >= levelsRequired;
    }

    public static long getExactXPForLevels(int levels) {
        return Experience.getExpFromLevel(levels);
    }

    public static int getExactLevelFromXP(long xp) {
        return Experience.getIntLevelFromExp(xp);
    }

    private ExperienceUtil() {
    }
}

