/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.Experience;
import com.falafel77.XPVault.XPVault;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class RetrieveXPTabCompleter
implements TabCompleter {
    private final XPVault plugin;

    public RetrieveXPTabCompleter(XPVault plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return new ArrayList<String>();
        }
        Player player = (Player)sender;
        long savedXP = this.plugin.getXpManager().getPlayerSavedXP(player);
        if (args.length == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            if (savedXP > 0L) {
                suggestions.add(String.valueOf(savedXP));
                int currentLevel = Experience.getIntLevelFromExp(Experience.getExp(player));
                int levelsToSuggest = Experience.getIntLevelFromExp(savedXP) - currentLevel;
                if (levelsToSuggest > 0) {
                    for (int i = 1; i <= levelsToSuggest; ++i) {
                        suggestions.add(i + "l");
                    }
                }
                if (savedXP >= 10L && !suggestions.contains("10")) {
                    suggestions.add("10");
                }
                if (savedXP >= 100L && !suggestions.contains("100")) {
                    suggestions.add("100");
                }
                if (savedXP >= 1000L && !suggestions.contains("1000")) {
                    suggestions.add("1000");
                }
            }
            return suggestions.stream().filter(s -> s.startsWith(args[0])).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }
}

