/*
 * Decompiled with CFR 0.152.
 */
package com.falafel77.XPVault;

import com.falafel77.XPVault.XPVault;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class XPManager {
    private final XPVault plugin;
    private File customConfigFile;
    private FileConfiguration customConfig;

    public XPManager(XPVault plugin) {
        this.plugin = plugin;
        this.setup();
    }

    public void setup() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdir();
        }
        this.customConfigFile = new File(this.plugin.getDataFolder(), "playerdata.yml");
        if (!this.customConfigFile.exists()) {
            try {
                this.customConfigFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerdata.yml!");
            }
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
    }

    public FileConfiguration getCustomConfig() {
        return this.customConfig;
    }

    public void saveCustomConfig() {
        try {
            this.customConfig.save(this.customConfigFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerdata.yml!");
        }
    }

    public void reloadCustomConfig() {
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
    }

    public long getPlayerSavedXP(Player player) {
        UUID playerUUID = player.getUniqueId();
        this.reloadCustomConfig();
        return this.customConfig.getLong(playerUUID.toString() + ".xp", 0L);
    }
}

