/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.organizableplayscreens.api;

import com.kevinthegreat.organizableplayscreens.gui.AbstractMultiplayerEntry;
import com.kevinthegreat.organizableplayscreens.gui.AbstractSingleplayerEntry;
import com.kevinthegreat.organizableplayscreens.gui.MultiplayerFolderEntry;
import com.kevinthegreat.organizableplayscreens.gui.MultiplayerSectionEntry;
import com.kevinthegreat.organizableplayscreens.gui.MultiplayerSeparatorEntry;
import com.kevinthegreat.organizableplayscreens.gui.SingleplayerFolderEntry;
import com.kevinthegreat.organizableplayscreens.gui.SingleplayerSectionEntry;
import com.kevinthegreat.organizableplayscreens.gui.SingleplayerSeparatorEntry;
import com.mojang.datafixers.util.Function3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_500;
import net.minecraft.class_526;
import org.jetbrains.annotations.NotNull;

public class EntryType {
    private static final Map<class_2960, EntryType> ENTRY_TYPE_MAP = new HashMap<class_2960, EntryType>();
    private static final List<EntryType> MULTIPLAYER_ENTRY_TYPES = new ArrayList<EntryType>();
    private static final List<EntryType> SINGLEPLAYER_ENTRY_TYPES = new ArrayList<EntryType>();
    public static final EntryType FOLDER = EntryType.register(class_2960.method_60655((String)"organizableplayscreens", (String)"folder"), (class_2561)class_2561.method_43471((String)"organizableplayscreens:folder.folder"), MultiplayerFolderEntry::new, (Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry>)((Function3)MultiplayerFolderEntry::new), SingleplayerFolderEntry::new, (Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry>)((Function3)SingleplayerFolderEntry::new));
    public static final EntryType SECTION = EntryType.register(class_2960.method_60655((String)"organizableplayscreens", (String)"section"), (class_2561)class_2561.method_43471((String)"organizableplayscreens:entry.section"), MultiplayerSectionEntry::new, (Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry>)((Function3)MultiplayerSectionEntry::new), SingleplayerSectionEntry::new, (Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry>)((Function3)SingleplayerSectionEntry::new));
    public static final EntryType SEPARATOR = EntryType.register(class_2960.method_60655((String)"organizableplayscreens", (String)"separator"), (class_2561)class_2561.method_43471((String)"organizableplayscreens:entry.separator"), MultiplayerSeparatorEntry::new, (Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry>)((Function3)MultiplayerSeparatorEntry::new), SingleplayerSeparatorEntry::new, (Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry>)((Function3)SingleplayerSeparatorEntry::new));
    private final class_2960 id;
    private final class_2561 text;
    private final BiFunction<class_500, MultiplayerFolderEntry, AbstractMultiplayerEntry> multiplayerNewEntryFactory;
    private final Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry> multiplayerEntryFactory;
    private final BiFunction<class_526, SingleplayerFolderEntry, AbstractSingleplayerEntry> singleplayerNewEntryFactory;
    private final Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry> singleplayerEntryFactory;

    private EntryType(class_2960 id, class_2561 text, BiFunction<class_500, MultiplayerFolderEntry, AbstractMultiplayerEntry> multiplayerNewEntryFactory, Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry> multiplayerEntryFactory, BiFunction<class_526, SingleplayerFolderEntry, AbstractSingleplayerEntry> singleplayerNewEntryFactory, Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry> singleplayerEntryFactory) {
        this.id = id;
        this.text = text;
        this.multiplayerNewEntryFactory = multiplayerNewEntryFactory;
        this.multiplayerEntryFactory = multiplayerEntryFactory;
        this.singleplayerNewEntryFactory = singleplayerNewEntryFactory;
        this.singleplayerEntryFactory = singleplayerEntryFactory;
    }

    public static EntryType register(@NotNull class_2960 id, @NotNull class_2561 text, BiFunction<class_500, MultiplayerFolderEntry, AbstractMultiplayerEntry> multiplayerNewEntryFactory, Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry> multiplayerEntryFactory, BiFunction<class_526, SingleplayerFolderEntry, AbstractSingleplayerEntry> singleplayerNewEntryFactory, Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry> singleplayerEntryFactory) {
        EntryType entryType = new EntryType(id, text, multiplayerNewEntryFactory, multiplayerEntryFactory, singleplayerNewEntryFactory, singleplayerEntryFactory);
        ENTRY_TYPE_MAP.put(id, entryType);
        if (multiplayerNewEntryFactory != null && multiplayerEntryFactory != null) {
            MULTIPLAYER_ENTRY_TYPES.add(entryType);
        }
        if (singleplayerNewEntryFactory != null && singleplayerEntryFactory != null) {
            SINGLEPLAYER_ENTRY_TYPES.add(entryType);
        }
        return entryType;
    }

    public static EntryType registerMultiplayer(@NotNull class_2960 id, @NotNull class_2561 text, @NotNull BiFunction<class_500, MultiplayerFolderEntry, AbstractMultiplayerEntry> multiplayerNewEntryFactory, @NotNull Function3<class_500, MultiplayerFolderEntry, String, AbstractMultiplayerEntry> multiplayerEntryFactory) {
        return EntryType.register(id, text, multiplayerNewEntryFactory, multiplayerEntryFactory, null, null);
    }

    public static EntryType registerSingleplayer(@NotNull class_2960 id, @NotNull class_2561 text, @NotNull BiFunction<class_526, SingleplayerFolderEntry, AbstractSingleplayerEntry> singleplayerNewEntryFactory, @NotNull Function3<class_526, SingleplayerFolderEntry, String, AbstractSingleplayerEntry> singleplayerEntryFactory) {
        return EntryType.register(id, text, null, null, singleplayerNewEntryFactory, singleplayerEntryFactory);
    }

    public static EntryType get(class_2960 id) {
        return ENTRY_TYPE_MAP.get(id);
    }

    public static List<EntryType> getMultiplayerEntryTypes() {
        return Collections.unmodifiableList(MULTIPLAYER_ENTRY_TYPES);
    }

    public static List<EntryType> getSingleplayerEntryTypes() {
        return Collections.unmodifiableList(SINGLEPLAYER_ENTRY_TYPES);
    }

    public class_2960 id() {
        return this.id;
    }

    public class_2561 text() {
        return this.text;
    }

    public AbstractMultiplayerEntry multiplayerEntry(class_500 screen, MultiplayerFolderEntry folder) {
        return this.multiplayerNewEntryFactory.apply(screen, folder);
    }

    public AbstractMultiplayerEntry multiplayerEntry(class_500 screen, MultiplayerFolderEntry folder, String name) {
        return (AbstractMultiplayerEntry)this.multiplayerEntryFactory.apply((Object)screen, (Object)folder, (Object)name);
    }

    public AbstractSingleplayerEntry singleplayerEntry(class_526 screen, SingleplayerFolderEntry folder) {
        return this.singleplayerNewEntryFactory.apply(screen, folder);
    }

    public AbstractSingleplayerEntry singleplayerEntry(class_526 screen, SingleplayerFolderEntry folder, String name) {
        return (AbstractSingleplayerEntry)this.singleplayerEntryFactory.apply((Object)screen, (Object)folder, (Object)name);
    }
}

