/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.organizableplayscreens.gui.screen;

import com.kevinthegreat.organizableplayscreens.api.EntryType;
import com.kevinthegreat.organizableplayscreens.gui.AbstractEntry;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;

public abstract class AbstractEditEntryScreen<T extends class_4280<E>, E extends class_4280.class_4281<E>>
extends class_437 {
    private final class_437 parent;
    private final BooleanConsumer callback;
    private final Function<EntryType, AbstractEntry<T, E>> factory;
    private AbstractEntry<T, E> entry;
    private final boolean newEntry;
    private class_2561 typeTitle;
    private class_2561 typeEnterName;
    private class_342 nameField;
    private final Map<EntryType, class_4185> entryTypeButtons = new HashMap<EntryType, class_4185>();
    private class_4185 buttonDone;

    public AbstractEditEntryScreen(class_437 parent, BooleanConsumer callback, Function<EntryType, AbstractEntry<T, E>> factory) {
        this(parent, callback, factory, factory.apply(EntryType.FOLDER), true);
    }

    public AbstractEditEntryScreen(class_437 parent, BooleanConsumer callback, AbstractEntry<T, E> entry) {
        this(parent, callback, type -> entry, entry, false);
    }

    private AbstractEditEntryScreen(class_437 parent, BooleanConsumer callback, Function<EntryType, AbstractEntry<T, E>> factory, AbstractEntry<T, E> entry, boolean newEntry) {
        super((class_2561)class_2561.method_43471((String)(newEntry ? "organizableplayscreens:entry.new" : "organizableplayscreens:entry.edit")));
        this.parent = parent;
        this.callback = callback;
        this.factory = factory;
        this.entry = entry;
        this.newEntry = newEntry;
    }

    protected abstract List<EntryType> getEntryTypes();

    protected void method_25426() {
        if (this.newEntry) {
            class_7845 gridWidget = new class_7845();
            List<EntryType> entryTypes = this.getEntryTypes();
            class_7845.class_7939 adder = gridWidget.method_47610(entryTypes.size());
            for (EntryType entryType : entryTypes) {
                this.entryTypeButtons.put(entryType, (class_4185)adder.method_47612((class_8021)((class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)entryType.text(), buttonWidget_ -> this.setType(entryType)).method_46432(50).method_46431()))));
            }
            gridWidget.method_48222();
            class_7843.method_46442((class_8021)gridWidget, (int)0, (int)40, (int)this.field_22789, (int)40);
        }
        this.typeTitle = class_2561.method_43469((String)(this.newEntry ? "organizableplayscreens:entry.new" : "organizableplayscreens:entry.edit"), (Object[])new Object[]{this.entry.getType().text().getString()});
        this.typeEnterName = class_2561.method_43469((String)"organizableplayscreens:entry.enterName", (Object[])new Object[]{this.entry.getType().text().getString()});
        this.nameField = new class_342(this.field_22793, this.field_22789 / 2 - 100, 90, 200, 20, this.typeEnterName);
        this.nameField.method_1880(128);
        this.nameField.method_25365(true);
        this.nameField.method_1852(this.entry.getValue());
        this.nameField.method_1863(this::updateDoneButton);
        this.method_37063((class_364)this.nameField);
        this.buttonDone = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, buttonWidget -> this.saveAndClose()).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 96 + 12, 200, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, buttonWidget -> this.callback.accept(false)).method_46434(this.field_22789 / 2 - 100, this.field_22790 / 4 + 120 + 12, 200, 20).method_46431());
        this.updateButtons();
    }

    private void setType(EntryType entryType) {
        this.entry = this.factory.apply(entryType);
        this.nameField.method_1852(this.entry.getValue());
        this.method_41843();
    }

    public boolean method_25404(class_11908 input) {
        if (!this.buttonDone.field_22763 || this.method_25399() != this.nameField || input.comp_4795() != 257 && input.comp_4795() != 335) {
            return super.method_25404(input);
        }
        this.saveAndClose();
        return true;
    }

    public void method_25410(class_310 client, int width, int height) {
        String folderName = this.nameField.method_1882();
        this.method_25423(client, width, height);
        this.nameField.method_1852(folderName);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private void saveAndClose() {
        this.entry.setValue(this.nameField.method_1882());
        this.callback.accept(true);
    }

    private void updateButtons() {
        if (this.newEntry) {
            EntryType currentType = this.entry.getType();
            for (Map.Entry<EntryType, class_4185> entry : this.entryTypeButtons.entrySet()) {
                entry.getValue().field_22763 = entry.getKey() != currentType;
            }
        }
        this.updateDoneButton(this.nameField.method_1882());
    }

    private void updateDoneButton(String text) {
        this.buttonDone.field_22763 = this.newEntry || !this.entry.getValue().equals(text);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_27534(this.field_22793, this.typeTitle, this.field_22789 / 2, 20, -1);
        context.method_27535(this.field_22793, this.typeEnterName, this.field_22789 / 2 - 100, 80, -6250336);
        this.nameField.method_25394(context, mouseX, mouseY, delta);
    }
}

