/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.organizableplayscreens.mixin;

import com.kevinthegreat.organizableplayscreens.OrganizablePlayScreens;
import com.kevinthegreat.organizableplayscreens.api.EntryType;
import com.kevinthegreat.organizableplayscreens.compatibility.Compatibility;
import com.kevinthegreat.organizableplayscreens.gui.AbstractMultiplayerEntry;
import com.kevinthegreat.organizableplayscreens.gui.MultiplayerFolderEntry;
import com.kevinthegreat.organizableplayscreens.gui.MultiplayerServerListWidgetAccessor;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.MultiplayerScreenAccessor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4267;
import net.minecraft.class_4280;
import net.minecraft.class_500;
import net.minecraft.class_642;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4267.class})
public abstract class MultiplayerServerListWidgetMixin
extends class_4280<class_4267.class_504>
implements MultiplayerServerListWidgetAccessor {
    @Shadow
    @Final
    private class_500 field_19108;
    @Shadow
    @Final
    private List<class_4267.class_4270> field_19109;
    @Shadow
    @Final
    private class_4267.class_504 field_19110;
    @Shadow
    @Final
    private List<class_4267.class_4269> field_19111;
    @Unique
    private static final Comparator<class_4267.class_4270> serverEntryComparator = Comparator.comparing(entry -> entry.method_20133().field_3761).thenComparing(entry -> entry.method_20133().field_3752);
    @Unique
    @NotNull
    private final MultiplayerFolderEntry organizableplayscreens_rootFolder;
    @Unique
    @NotNull
    private MultiplayerFolderEntry organizableplayscreens_currentFolder;
    @Unique
    private class_7842 organizableplayscreens_pathWidget;

    @Shadow
    protected abstract void method_20131();

    public MultiplayerServerListWidgetMixin(class_310 minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
        this.organizableplayscreens_currentFolder = this.organizableplayscreens_rootFolder = new MultiplayerFolderEntry(this.field_19108, null, "root");
    }

    @Override
    public MultiplayerFolderEntry organizableplayscreens_getCurrentFolder() {
        return this.organizableplayscreens_currentFolder;
    }

    @Override
    public List<class_4267.class_504> organizableplayscreens_getCurrentEntries() {
        return this.organizableplayscreens_currentFolder.getEntries();
    }

    @Override
    public boolean organizableplayscreens_isRootFolder() {
        return this.organizableplayscreens_currentFolder == this.organizableplayscreens_rootFolder;
    }

    @Override
    public void organizableplayscreens_setPathWidget(class_7842 pathWidget) {
        this.organizableplayscreens_pathWidget = pathWidget;
    }

    @Override
    public void organizableplayscreens_setCurrentFolder(@NotNull MultiplayerFolderEntry folderEntry) {
        this.organizableplayscreens_currentFolder = folderEntry;
        this.method_25313(null);
        this.method_20131();
    }

    @Override
    public boolean organizableplayscreens_setCurrentFolderToParent() {
        if (this.organizableplayscreens_currentFolder != this.organizableplayscreens_rootFolder) {
            MultiplayerFolderEntry oldCurrentFolder = this.organizableplayscreens_currentFolder;
            this.organizableplayscreens_setCurrentFolder(this.organizableplayscreens_currentFolder.getParent());
            this.method_25313((class_350.class_351)oldCurrentFolder);
            return true;
        }
        return false;
    }

    @Override
    public void organizableplayscreens_loadFile() {
        try {
            class_2487 nbtCompound = class_2507.method_10633((Path)this.field_22740.field_1697.toPath().resolve("organizable_servers.dat"));
            ArrayList<class_4267.class_4270> serversSorted = new ArrayList<class_4267.class_4270>(this.field_19109);
            serversSorted.sort(serverEntryComparator);
            if (nbtCompound != null) {
                this.organizableplayscreens_fromNbt(this.organizableplayscreens_rootFolder, nbtCompound, serversSorted);
            }
            for (class_4267.class_4270 serverEntry : this.field_19109) {
                if (!serversSorted.contains(serverEntry)) continue;
                this.organizableplayscreens_currentFolder.getEntries().add((class_4267.class_504)serverEntry);
            }
            this.method_20131();
        }
        catch (Exception e) {
            OrganizablePlayScreens.LOGGER.error("Couldn't load server and folder list", (Throwable)e);
        }
    }

    @Override
    public void organizableplayscreens_saveFile() {
        try {
            class_2487 nbtCompound = this.organizableplayscreens_toNbt(this.organizableplayscreens_rootFolder);
            Path runDirectory = this.field_22740.field_1697.toPath();
            Path tempFile = Files.createTempFile(runDirectory, "organizable_servers", ".dat", new FileAttribute[0]);
            class_2507.method_10630((class_2487)nbtCompound, (Path)tempFile);
            Path backup = runDirectory.resolve("organizable_servers.dat_old");
            Path file = runDirectory.resolve("organizable_servers.dat");
            class_156.method_30626((Path)file, (Path)tempFile, (Path)backup);
        }
        catch (Exception e) {
            OrganizablePlayScreens.LOGGER.error("Couldn't save server and folder list", (Throwable)e);
        }
    }

    @Override
    public void organizableplayscreens_updateAndSave() {
        this.method_20131();
        this.organizableplayscreens_saveFile();
    }

    @Unique
    private void organizableplayscreens_fromNbt(MultiplayerFolderEntry folder, class_2487 nbtCompound, List<class_4267.class_4270> serversSorted) {
        class_2499 nbtList = nbtCompound.method_68569("entries");
        folder.getEntries().clear();
        block8: for (int i = 0; i < nbtList.size(); ++i) {
            String type;
            class_2487 nbtEntry = nbtList.method_68582(i);
            OrganizablePlayScreens.updateEntryNbt(nbtEntry, true);
            switch (type = nbtEntry.method_68564("type", "")) {
                case "minecraft:server": {
                    int index;
                    if (nbtEntry.method_68566("hidden", false) || (index = Collections.binarySearch(serversSorted, ServerEntryInvoker.create((class_4267)this, this.field_19108, new class_642(nbtEntry.method_68564("name", ""), nbtEntry.method_68564("ip", ""), null)), serverEntryComparator)) < 0) continue block8;
                    folder.getEntries().add((class_4267.class_504)serversSorted.remove(index));
                    continue block8;
                }
                case "organizableplayscreens:folder": {
                    MultiplayerFolderEntry folderEntry = new MultiplayerFolderEntry(this.field_19108, folder, nbtEntry.method_68564("name", ""));
                    if (nbtEntry.method_68566("current", false)) {
                        this.organizableplayscreens_currentFolder = folderEntry;
                    }
                    this.organizableplayscreens_fromNbt(folderEntry, nbtEntry, serversSorted);
                    folder.getEntries().add(folderEntry);
                    continue block8;
                }
                default: {
                    folder.getEntries().add(EntryType.get(class_2960.method_60654((String)type)).multiplayerEntry(this.field_19108, folder, nbtEntry.method_68564("name", "")));
                }
            }
        }
    }

    @Unique
    private class_2487 organizableplayscreens_toNbt(MultiplayerFolderEntry folder) {
        class_2499 nbtList = new class_2499();
        for (class_4267.class_504 entry : folder.getEntries()) {
            class_2487 nbtEntry;
            if (entry instanceof class_4267.class_4270) {
                class_4267.class_4270 serverEntry = (class_4267.class_4270)entry;
                nbtEntry = new class_2487();
                nbtEntry.method_10582("type", "minecraft:server");
                nbtEntry.method_10582("ip", serverEntry.method_20133().field_3761);
                nbtEntry.method_10582("name", serverEntry.method_20133().field_3752);
                nbtEntry.method_10556("hidden", false);
                nbtList.add((Object)nbtEntry);
                continue;
            }
            if (!(entry instanceof AbstractMultiplayerEntry)) continue;
            AbstractMultiplayerEntry nonServerEntry = (AbstractMultiplayerEntry)entry;
            nbtEntry = new class_2487();
            if (nonServerEntry instanceof MultiplayerFolderEntry) {
                MultiplayerFolderEntry folderEntry = (MultiplayerFolderEntry)nonServerEntry;
                nbtEntry = this.organizableplayscreens_toNbt(folderEntry);
                if (folderEntry == this.organizableplayscreens_currentFolder) {
                    nbtEntry.method_10556("current", true);
                }
            }
            nbtEntry.method_10582("type", nonServerEntry.getType().id().toString());
            nbtEntry.method_10582("name", nonServerEntry.getName());
            nbtList.add((Object)nbtEntry);
        }
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10566("entries", (class_2520)nbtList);
        return nbtCompound;
    }

    @Override
    public void organizableplayscreens_swapEntries(int i, int j) {
        Collections.swap(this.organizableplayscreens_currentFolder.getEntries(), i, j);
        this.organizableplayscreens_updateAndSave();
        this.method_25313((class_350.class_351)((class_4267.class_504)this.method_25396().get(j)));
        this.method_73377((class_350.class_351)((class_4267.class_504)this.method_25334()));
    }

    @Inject(method={"updateEntries"}, at={@At(value="HEAD")}, cancellable=true)
    private void organizableplayscreens_updateEntries(CallbackInfo ci) {
        if (Compatibility.essential_preventMultiplayerFeatures()) {
            return;
        }
        this.method_25339();
        this.organizableplayscreens_currentFolder.getEntries().forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        this.method_25321((class_350.class_351)this.field_19110);
        this.field_19111.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        if (this.method_25334() == null) {
            this.method_44382(0.0);
        }
        this.organizableplayscreens_updateCurrentPath();
        ci.cancel();
    }

    @Unique
    private void organizableplayscreens_updateCurrentPath() {
        ArrayList<String> path = new ArrayList<String>();
        MultiplayerFolderEntry folder = this.organizableplayscreens_currentFolder;
        while (folder.getParent() != null) {
            path.add(folder.getName());
            folder = folder.getParent();
        }
        Collections.reverse(path);
        this.organizableplayscreens_pathWidget.method_25355(class_2561.method_30163((String)String.join((CharSequence)" > ", path)));
        ((MultiplayerScreenAccessor)this.field_19108).invokeRefreshWidgetPositions();
    }

    @Mixin(value={class_4267.class_4270.class})
    public static interface ServerEntryInvoker {
        @Invoker(value="<init>")
        public static class_4267.class_4270 create(class_4267 serverListWidget, class_500 screen, class_642 server) {
            throw new IllegalStateException("Mixin invoker failed to apply");
        }
    }
}

