/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.organizableplayscreens.option;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kevinthegreat.organizableplayscreens.OrganizablePlayScreens;
import com.kevinthegreat.organizableplayscreens.gui.screen.OrganizablePlayScreensOptionsScreen;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.MultiplayerScreenAccessor;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.SelectWorldScreenAccessor;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.SimpleOptionAccessor;
import com.kevinthegreat.organizableplayscreens.option.BothSuppliableIntSliderCallbacks;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.UnaryOperator;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_7172;

public class OrganizablePlayScreensOptions {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final class_2561 X = class_2561.method_43471((String)"organizableplayscreens:options.x");
    public static final class_2561 Y = class_2561.method_43471((String)"organizableplayscreens:options.y");
    public static final String[] KEYS = new String[]{"organizableplayscreens:options.backButton", "organizableplayscreens:options.moveEntryBackButton", "organizableplayscreens:options.newFolderButton", "organizableplayscreens:options.optionsButton", "organizableplayscreens:options.moveEntryIntoButton"};
    private final Path optionsFile = FabricLoader.getInstance().getConfigDir().resolve("organizableplayscreens.json");
    public final class_7172<Boolean> buttonType = new class_7172("organizableplayscreens:options.buttonType", class_7172.method_42399(), (optionText, value) -> class_2561.method_43471((String)(value != false ? "organizableplayscreens:options.textField" : "organizableplayscreens:options.slider")), (class_7172.class_7178)class_7172.field_38278, (Object)false, value -> {
        class_437 patt0$temp = class_310.method_1551().field_1755;
        if (patt0$temp instanceof OrganizablePlayScreensOptionsScreen) {
            OrganizablePlayScreensOptionsScreen organizablePlayScreensOptionsScreen = (OrganizablePlayScreensOptionsScreen)patt0$temp;
            class_310.method_1551().method_1507((class_437)new OrganizablePlayScreensOptionsScreen(organizablePlayScreensOptionsScreen.getParent()));
        }
    });
    public final class_7172<Integer> backButtonX;
    public final class_7172<Integer> backButtonY;
    public final class_7172<Integer> moveEntryBackButtonX;
    public final class_7172<Integer> moveEntryBackButtonY;
    public final class_7172<Integer> newFolderButtonX;
    public final class_7172<Integer> newFolderButtonY;
    public final class_7172<Integer> optionsButtonX;
    public final class_7172<Integer> optionsButtonY;
    public final class_7172<Integer> moveEntryIntoButtonX;
    public final class_7172<Integer> moveEntryIntoButtonY;
    public final List<List<class_3545<String, class_7172<?>>>> optionsArray;

    public OrganizablePlayScreensOptions() {
        this.backButtonX = new class_7172(KEYS[0] + ".x", class_7172.method_42399(), ScreenRelativeCallbacks.LEFT.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.LEFT, this.buttonType), (Object)8, value -> this.updateResetButton(0));
        this.backButtonY = new class_7172(KEYS[0] + ".y", class_7172.method_42399(), ScreenRelativeCallbacks.TOP.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.TOP, this.buttonType), (Object)8, value -> this.updateResetButton(0));
        this.moveEntryBackButtonX = new class_7172(KEYS[1] + ".x", class_7172.method_42399(), ScreenRelativeCallbacks.LEFT.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.LEFT, this.buttonType), (Object)36, value -> this.updateResetButton(1));
        this.moveEntryBackButtonY = new class_7172(KEYS[1] + ".y", class_7172.method_42399(), ScreenRelativeCallbacks.TOP.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.TOP, this.buttonType), (Object)8, value -> this.updateResetButton(1));
        this.newFolderButtonX = new class_7172(KEYS[2] + ".x", class_7172.method_42399(), ScreenRelativeCallbacks.RIGHT.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.RIGHT, this.buttonType), (Object)-56, value -> this.updateResetButton(2));
        this.newFolderButtonY = new class_7172(KEYS[2] + ".y", class_7172.method_42399(), ScreenRelativeCallbacks.TOP.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.TOP, this.buttonType), (Object)8, value -> this.updateResetButton(2));
        this.optionsButtonX = new class_7172(KEYS[3] + ".x", class_7172.method_42399(), ScreenRelativeCallbacks.RIGHT.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.RIGHT, this.buttonType), (Object)-28, value -> this.updateResetButton(3));
        this.optionsButtonY = new class_7172(KEYS[3] + ".y", class_7172.method_42399(), ScreenRelativeCallbacks.TOP.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.TOP, this.buttonType), (Object)8, value -> this.updateResetButton(3));
        this.moveEntryIntoButtonX = new class_7172(KEYS[4] + ".x", class_7172.method_42399(), ScreenRelativeCallbacks.RIGHT_LIST_WIDGET.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(ScreenRelativeCallbacks.RIGHT_LIST_WIDGET, this.buttonType), (Object)-30, value -> this.updateResetButton(4));
        this.moveEntryIntoButtonY = new class_7172(KEYS[4] + ".y", class_7172.method_42399(), ScreenRelativeCallbacks.TOP.displayValueTextGetter, (class_7172.class_7178)new BothSuppliableIntSliderCallbacks(0, 12, this.buttonType), (Object)6, value -> this.updateResetButton(4));
        this.optionsArray = List.of(List.of(new class_3545((Object)"backButton_x", this.backButtonX), new class_3545((Object)"backButton_y", this.backButtonY)), List.of(new class_3545((Object)"moveEntryBackButton_x", this.moveEntryBackButtonX), new class_3545((Object)"moveEntryBackButton_y", this.moveEntryBackButtonY)), List.of(new class_3545((Object)"newFolderButton_x", this.newFolderButtonX), new class_3545((Object)"newFolderButton_y", this.newFolderButtonY)), List.of(new class_3545((Object)"optionsButton_x", this.optionsButtonX), new class_3545((Object)"optionsButton_y", this.optionsButtonY)), List.of(new class_3545((Object)"moveEntryIntoButton_x", this.moveEntryIntoButtonX), new class_3545((Object)"moveEntryIntoButton_y", this.moveEntryIntoButtonY)), List.of(new class_3545((Object)"buttonType", this.buttonType)));
        this.load();
    }

    private static int fromRightRelative(int value) {
        return class_310.method_1551().field_1755 == null ? 0 : class_310.method_1551().field_1755.field_22789 + value;
    }

    private static int fromRightRelativeListWidget(int value) {
        return OrganizablePlayScreensOptions.getListWidgetRight() + value;
    }

    private static int getListWidgetRight() {
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof OrganizablePlayScreensOptionsScreen) {
            OrganizablePlayScreensOptionsScreen optionsScreen = (OrganizablePlayScreensOptionsScreen)screen;
            screen = optionsScreen.getParent();
        }
        if (screen instanceof class_500) {
            class_500 multiplayerScreen = (class_500)screen;
            return ((MultiplayerScreenAccessor)multiplayerScreen).getServerListWidget().method_31383();
        }
        if (screen instanceof class_526) {
            class_526 selectWorldScreen = (class_526)screen;
            return ((SelectWorldScreenAccessor)selectWorldScreen).getLevelList().method_31383();
        }
        return screen == null ? 0x7FFFFFFE : screen.field_22789 * 5 / 6;
    }

    public void load() {
        JsonObject optionsJson;
        if (!Files.isRegularFile(this.optionsFile, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(this.optionsFile);){
            optionsJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (FileNotFoundException e) {
            OrganizablePlayScreens.LOGGER.warn("Options file not found", (Throwable)e);
            return;
        }
        catch (IOException e) {
            OrganizablePlayScreens.LOGGER.error("Failed to load options", (Throwable)e);
            return;
        }
        for (List<class_3545<String, class_7172<?>>> optionRow : this.optionsArray) {
            for (class_3545<String, class_7172<?>> namedOption : optionRow) {
                this.parseOption(optionsJson, (String)namedOption.method_15442(), (class_7172)namedOption.method_15441());
            }
        }
    }

    private <T> void parseOption(JsonObject optionsJson, String name, class_7172<T> option) {
        DataResult dataResult = option.method_42404().parse((DynamicOps)JsonOps.INSTANCE, (Object)optionsJson.get(name));
        dataResult.ifError(error -> OrganizablePlayScreens.LOGGER.error("Error parsing option value {} for option {}: {}", new Object[]{optionsJson.get(name), name, error}));
        dataResult.ifSuccess(arg_0 -> option.method_41748(arg_0));
    }

    public void save() {
        Path tempFile;
        JsonObject optionsJson = new JsonObject();
        for (List<class_3545<String, class_7172<?>>> optionRow : this.optionsArray) {
            for (class_3545<String, class_7172<?>> namedOption : optionRow) {
                this.saveOption(optionsJson, (String)namedOption.method_15442(), (class_7172)namedOption.method_15441());
            }
        }
        try {
            tempFile = Files.createTempFile(this.optionsFile.getParent(), "organizableplayscreens", ".json", new FileAttribute[0]);
        }
        catch (IOException e) {
            OrganizablePlayScreens.LOGGER.error("Failed to save options file", (Throwable)e);
            return;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(tempFile, new OpenOption[0]);){
            GSON.toJson((JsonElement)optionsJson, (Appendable)writer);
        }
        catch (IOException e) {
            OrganizablePlayScreens.LOGGER.error("Failed to write options", (Throwable)e);
        }
        Path backup = this.optionsFile.getParent().resolve("organizableplayscreens.json_old");
        class_156.method_30626((Path)this.optionsFile, (Path)tempFile, (Path)backup);
    }

    private <T> void saveOption(JsonObject optionsJson, String name, class_7172<T> option) {
        DataResult dataResult = option.method_42404().encodeStart((DynamicOps)JsonOps.INSTANCE, option.method_41753());
        dataResult.ifError(error -> OrganizablePlayScreens.LOGGER.error("Error encoding option value {} for option {}: {}", new Object[]{option.method_41753(), name, error}));
        dataResult.ifSuccess(optionJson -> optionsJson.add(name, optionJson));
    }

    public int getValue(class_7172<Integer> option) {
        int n;
        class_7172.class_7178 class_71782 = option.method_41754();
        if (class_71782 instanceof BothSuppliableIntSliderCallbacks) {
            BothSuppliableIntSliderCallbacks suppliableCallbacks = (BothSuppliableIntSliderCallbacks)class_71782;
            n = (Integer)suppliableCallbacks.displayValueGetter().apply((Integer)option.method_41753());
        } else {
            n = (Integer)option.method_41753();
        }
        return n;
    }

    public void updateResetButtons() {
        for (int i = 0; i < 5; ++i) {
            this.updateResetButton(i);
        }
    }

    public void updateResetButton(int row) {
        class_437 class_4372 = class_310.method_1551().field_1755;
        if (class_4372 instanceof OrganizablePlayScreensOptionsScreen) {
            OrganizablePlayScreensOptionsScreen optionsScreen = (OrganizablePlayScreensOptionsScreen)class_4372;
            optionsScreen.updateResetButton(row, this.optionsArray.get(row).stream().map(class_3545::method_15441).anyMatch(OrganizablePlayScreensOptions::notDefault));
        }
    }

    public static <T> boolean notDefault(class_7172<T> option) {
        return option.method_41753() != ((SimpleOptionAccessor)option).getDefaultValue();
    }

    public static void reset(List<class_3545<String, class_7172<?>>> options) {
        for (class_3545<String, class_7172<?>> option : options) {
            OrganizablePlayScreensOptions.reset((class_7172)option.method_15441());
        }
    }

    public static <T> void reset(class_7172<T> option) {
        option.method_41748(((SimpleOptionAccessor)option).getDefaultValue());
    }

    public static enum ScreenRelativeCallbacks {
        LEFT(0, () -> class_310.method_1551().field_1755 == null ? 0x7FFFFFFE : class_310.method_1551().field_1755.field_22789 - 20, X),
        RIGHT(() -> class_310.method_1551().field_1755 == null ? Integer.MIN_VALUE : -class_310.method_1551().field_1755.field_22789, -20, string -> class_310.method_1551().field_1755 == null ? 0 : Integer.parseInt(string) - class_310.method_1551().field_1755.field_22789, OrganizablePlayScreensOptions::fromRightRelative, (class_7172.class_7303<Integer>)((class_7172.class_7303)(optionText, value) -> class_315.method_41782((class_2561)X, (int)value))),
        RIGHT_LIST_WIDGET(() -> -OrganizablePlayScreensOptions.getListWidgetRight(), () -> class_310.method_1551().field_1755 == null ? 0x7FFFFFFE : class_310.method_1551().field_1755.field_22789 - OrganizablePlayScreensOptions.getListWidgetRight() - 20, string -> class_310.method_1551().field_1755 == null ? 0 : Integer.parseInt(string) - OrganizablePlayScreensOptions.getListWidgetRight(), OrganizablePlayScreensOptions::fromRightRelativeListWidget, (class_7172.class_7303<Integer>)((class_7172.class_7303)(optionText, value) -> class_315.method_41782((class_2561)X, (int)value))),
        TOP(0, () -> class_310.method_1551().field_1755 == null ? 0x7FFFFFFE : class_310.method_1551().field_1755.field_22790 - 20, Y);

        public final IntSupplier minSupplier;
        public final IntSupplier maxSupplier;
        public final Function<String, Integer> displayValueParser;
        public final UnaryOperator<Integer> displayValueGetter;
        public final class_7172.class_7303<Integer> displayValueTextGetter;

        private ScreenRelativeCallbacks(int minInclusive, IntSupplier maxSupplier, class_2561 displayTextPrefix) {
            this(() -> minInclusive, maxSupplier, Integer::parseInt, UnaryOperator.identity(), (class_7172.class_7303<Integer>)((class_7172.class_7303)(optionText, value) -> class_315.method_41782((class_2561)displayTextPrefix, (int)value)));
        }

        private ScreenRelativeCallbacks(IntSupplier minSupplier, int maxInclusive, Function<String, Integer> displayValueParser, UnaryOperator<Integer> displayValueGetter, class_7172.class_7303<Integer> valueTextGetter) {
            this(minSupplier, () -> maxInclusive, displayValueParser, displayValueGetter, valueTextGetter);
        }

        private ScreenRelativeCallbacks(IntSupplier minSupplier, IntSupplier maxSupplier, Function<String, Integer> displayValueParser, UnaryOperator<Integer> displayValueGetter, class_7172.class_7303<Integer> valueTextGetter) {
            this.minSupplier = minSupplier;
            this.maxSupplier = maxSupplier;
            this.displayValueParser = displayValueParser;
            this.displayValueGetter = displayValueGetter;
            this.displayValueTextGetter = (optionText, value) -> valueTextGetter.toString(optionText, (Object)((Integer)displayValueGetter.apply((Integer)value)));
        }
    }
}

