/*
 * Decompiled with CFR 0.152.
 */
package com.kevinthegreat.organizableplayscreens.mixin;

import com.kevinthegreat.organizableplayscreens.OrganizablePlayScreens;
import com.kevinthegreat.organizableplayscreens.api.EntryType;
import com.kevinthegreat.organizableplayscreens.gui.AbstractSingleplayerEntry;
import com.kevinthegreat.organizableplayscreens.gui.SingleplayerFolderEntry;
import com.kevinthegreat.organizableplayscreens.gui.WorldListWidgetAccessor;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.SaveVersionInfoInvoker;
import com.kevinthegreat.organizableplayscreens.mixin.accessor.SelectWorldScreenAccessor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.class_156;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_34;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_526;
import net.minecraft.class_528;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_528.class})
public abstract class WorldListWidgetMixin
extends class_4280<class_528.class_7414>
implements WorldListWidgetAccessor {
    @Shadow
    @Final
    private class_437 field_3237;
    @Shadow
    private CompletableFuture<List<class_34>> field_39739;
    @Shadow
    private String field_39738;
    @Unique
    private CompletableFuture<Void> organizableplayscreens_loadedFuture;
    @Unique
    private final SingleplayerFolderEntry organizableplayscreens_rootFolder;
    @Unique
    private SingleplayerFolderEntry organizableplayscreens_currentFolder;
    @Unique
    private final SortedMap<class_528.class_4272, SingleplayerFolderEntry> organizableplayscreens_worlds;
    @Unique
    private class_7842 organizableplayscreens_pathWidget;

    @Shadow
    protected abstract boolean method_43453(String var1, class_34 var2);

    @Shadow
    protected abstract void method_43464();

    @Shadow
    public abstract void method_20157(@Nullable class_528.class_7414 var1);

    public WorldListWidgetMixin(class_310 minecraftClient, int i, int j, int k, int l) {
        super(minecraftClient, i, j, k, l);
        this.organizableplayscreens_currentFolder = this.organizableplayscreens_rootFolder = new SingleplayerFolderEntry((class_526)this.field_3237, null, "root");
        this.organizableplayscreens_worlds = new TreeMap<class_528.class_4272, SingleplayerFolderEntry>(Comparator.comparing(worldEntry -> ((WorldEntryAccessor)worldEntry).getLevel()));
    }

    @Override
    public SingleplayerFolderEntry organizableplayscreens_getCurrentFolder() {
        return this.organizableplayscreens_currentFolder;
    }

    @Override
    public List<AbstractSingleplayerEntry> organizableplayscreens_getCurrentNonWorldEntries() {
        return this.organizableplayscreens_currentFolder.getNonWorldEntries();
    }

    @Override
    public List<class_528.class_4272> organizableplayscreens_getCurrentWorldEntries() {
        return this.organizableplayscreens_currentFolder.getWorldEntries();
    }

    @Override
    public SortedMap<class_528.class_4272, SingleplayerFolderEntry> organizableplayscreens_getWorlds() {
        return this.organizableplayscreens_worlds;
    }

    @Override
    public boolean organizableplayscreens_isRootFolder() {
        return this.organizableplayscreens_currentFolder == this.organizableplayscreens_rootFolder;
    }

    @Override
    public void organizableplayscreens_setPathWidget(class_7842 pathWidget) {
        this.organizableplayscreens_pathWidget = pathWidget;
    }

    @Override
    public void organizableplayscreens_setCurrentFolder(@NotNull SingleplayerFolderEntry folderEntry) {
        this.organizableplayscreens_currentFolder = folderEntry;
        this.method_20157(null);
        this.organizableplayscreens_updateEntries();
    }

    @Override
    public boolean organizableplayscreens_setCurrentFolderToParent() {
        if (this.organizableplayscreens_currentFolder != this.organizableplayscreens_rootFolder) {
            SingleplayerFolderEntry oldCurrentFolder = this.organizableplayscreens_currentFolder;
            this.organizableplayscreens_setCurrentFolder(this.organizableplayscreens_currentFolder.getParent());
            this.method_20157(oldCurrentFolder);
            return true;
        }
        return false;
    }

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screen/world/WorldListWidget;levelsFuture:Ljava/util/concurrent/CompletableFuture;", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
    private void organizableplayscreens_loadFromListWidget(class_437 parent, class_310 client, int width, int height, String search, class_528 oldWidget, Consumer<class_34> selectionCallback, Consumer<class_528.class_4272> confirmationCallback, class_528.class_11781 worldListType, CallbackInfo ci) {
        this.organizableplayscreens_loadedFuture = ((WorldListWidgetMixin)oldWidget).organizableplayscreens_loadedFuture.thenRunAsync(() -> {
            this.organizableplayscreens_worlds.clear();
            this.organizableplayscreens_fromFolder(this.organizableplayscreens_rootFolder, ((WorldListWidgetMixin)oldWidget).organizableplayscreens_rootFolder, ((WorldListWidgetMixin)oldWidget).organizableplayscreens_currentFolder);
            this.organizableplayscreens_pathWidget = ((WorldListWidgetMixin)oldWidget).organizableplayscreens_pathWidget;
            this.organizableplayscreens_updateEntries();
            this.method_20157(null);
        }, (Executor)client);
    }

    @Inject(method={"<init>"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screen/world/WorldListWidget;levelsFuture:Ljava/util/concurrent/CompletableFuture;", opcode=181, ordinal=1, shift=At.Shift.AFTER)})
    public void organizableplayscreens_loadFileOnInit(CallbackInfo ci) {
        this.organizableplayscreens_loadFile(ci);
    }

    @Inject(method={"load"}, at={@At(value="FIELD", target="Lnet/minecraft/client/gui/screen/world/WorldListWidget;levelsFuture:Ljava/util/concurrent/CompletableFuture;", opcode=181, ordinal=0, shift=At.Shift.AFTER)})
    public void organizableplayscreens_loadFile(CallbackInfo ci) {
        this.organizableplayscreens_rootFolder.getNonWorldEntries().clear();
        this.organizableplayscreens_rootFolder.getWorldEntries().clear();
        this.organizableplayscreens_loadedFuture = this.field_39739.thenAcceptAsync(levels -> {
            try {
                this.organizableplayscreens_fromNbtAndUpdate(class_2507.method_10633((Path)this.field_22740.field_1697.toPath().resolve("organizable_worlds.dat")), (List<class_34>)levels);
            }
            catch (Exception e) {
                OrganizablePlayScreens.LOGGER.error("Couldn't load world and folder list", (Throwable)e);
            }
        }, (Executor)this.field_22740);
    }

    @Unique
    private void organizableplayscreens_fromNbtAndUpdate(class_2487 nbtCompound, List<class_34> levels) {
        levels = new ArrayList<class_34>(levels);
        if (nbtCompound != null) {
            this.organizableplayscreens_fromNbt(this.organizableplayscreens_rootFolder, nbtCompound, levels);
        }
        for (class_34 levelSummary : levels) {
            class_528.class_4272 worldEntry = new class_528.class_4272((class_528)this, levelSummary);
            this.organizableplayscreens_worlds.put(worldEntry, this.organizableplayscreens_currentFolder);
            this.organizableplayscreens_currentFolder.getWorldEntries().add(worldEntry);
        }
        OrganizablePlayScreens.sortWorldEntries(this.organizableplayscreens_currentFolder.getWorldEntries());
        this.organizableplayscreens_updateEntries();
        this.method_20157(null);
    }

    @Unique
    private void organizableplayscreens_fromNbt(SingleplayerFolderEntry folder, class_2487 nbtCompound, List<class_34> levels) {
        class_2499 nbtList = nbtCompound.method_68569("entries");
        folder.getWorldEntries().clear();
        folder.getNonWorldEntries().clear();
        block8: for (int i = 0; i < nbtList.size(); ++i) {
            String type;
            class_2487 nbtEntry = nbtList.method_68582(i);
            OrganizablePlayScreens.updateEntryNbt(nbtEntry, false);
            switch (type = nbtEntry.method_68564("type", "")) {
                case "minecraft:world": {
                    int index = Collections.binarySearch(levels, new class_34(null, SaveVersionInfoInvoker.create(0, nbtEntry.method_68080("lastPlayed", 0L), null, 0, null, false), nbtEntry.method_68564("name", ""), false, false, false, null));
                    if (index < 0) continue block8;
                    class_528.class_4272 worldEntry = new class_528.class_4272((class_528)this, levels.get(index));
                    this.organizableplayscreens_worlds.put(worldEntry, folder);
                    folder.getWorldEntries().add(worldEntry);
                    levels.remove(index);
                    continue block8;
                }
                case "organizableplayscreens:folder": {
                    SingleplayerFolderEntry folderEntry = new SingleplayerFolderEntry((class_526)this.field_3237, folder, nbtEntry.method_68564("name", ""));
                    if (nbtEntry.method_68566("current", false)) {
                        this.organizableplayscreens_currentFolder = folderEntry;
                    }
                    this.organizableplayscreens_fromNbt(folderEntry, nbtEntry, levels);
                    folder.getNonWorldEntries().add(folderEntry);
                    continue block8;
                }
                default: {
                    folder.getNonWorldEntries().add(EntryType.get(class_2960.method_60654((String)type)).singleplayerEntry((class_526)this.field_3237, folder, nbtEntry.method_68564("name", "")));
                }
            }
        }
    }

    @Unique
    private void organizableplayscreens_fromFolder(SingleplayerFolderEntry newFolder, SingleplayerFolderEntry oldFolder, SingleplayerFolderEntry oldCurrentFolder) {
        newFolder.getWorldEntries().clear();
        newFolder.getNonWorldEntries().clear();
        for (class_528.class_4272 oldWorldEntry : oldFolder.getWorldEntries()) {
            class_528.class_4272 newWorldEntry = new class_528.class_4272((class_528)this, ((WorldEntryAccessor)oldWorldEntry).getLevel());
            this.organizableplayscreens_worlds.put(newWorldEntry, newFolder);
            newFolder.getWorldEntries().add(newWorldEntry);
        }
        for (AbstractSingleplayerEntry oldNonWorldEntry : oldFolder.getNonWorldEntries()) {
            if (oldNonWorldEntry instanceof SingleplayerFolderEntry) {
                SingleplayerFolderEntry oldFolderEntry = (SingleplayerFolderEntry)oldNonWorldEntry;
                SingleplayerFolderEntry newFolderEntry = new SingleplayerFolderEntry((class_526)this.field_3237, newFolder, oldFolderEntry.getName());
                this.organizableplayscreens_fromFolder(newFolderEntry, oldFolderEntry, oldCurrentFolder);
                newFolder.getNonWorldEntries().add(newFolderEntry);
                continue;
            }
            newFolder.getNonWorldEntries().add(oldNonWorldEntry.getType().singleplayerEntry((class_526)this.field_3237, newFolder, oldNonWorldEntry.getName()));
        }
        if (oldCurrentFolder == oldFolder) {
            this.organizableplayscreens_currentFolder = newFolder;
        }
    }

    @Override
    public void organizableplayscreens_updateAndSave() {
        this.organizableplayscreens_updateEntries();
        this.organizableplayscreens_saveFile();
    }

    @Override
    public void organizableplayscreens_saveFile() {
        try {
            class_2487 nbtCompound = this.organizableplayscreens_toNbt(this.organizableplayscreens_rootFolder);
            Path runDirectory = this.field_22740.field_1697.toPath();
            Path tempFile = Files.createTempFile(runDirectory, "organizable_worlds", ".dat", new FileAttribute[0]);
            class_2507.method_10630((class_2487)nbtCompound, (Path)tempFile);
            Path backup = runDirectory.resolve("organizable_worlds.dat_old");
            Path file = runDirectory.resolve("organizable_worlds.dat");
            class_156.method_30626((Path)file, (Path)tempFile, (Path)backup);
        }
        catch (Exception e) {
            OrganizablePlayScreens.LOGGER.error("Couldn't save world and folder list", (Throwable)e);
        }
    }

    @Unique
    private class_2487 organizableplayscreens_toNbt(SingleplayerFolderEntry folder) {
        class_2487 nbtEntry;
        class_2499 nbtList = new class_2499();
        for (AbstractSingleplayerEntry nonWorldEntry : folder.getNonWorldEntries()) {
            nbtEntry = new class_2487();
            if (nonWorldEntry instanceof SingleplayerFolderEntry) {
                SingleplayerFolderEntry folderEntry = (SingleplayerFolderEntry)nonWorldEntry;
                nbtEntry = this.organizableplayscreens_toNbt(folderEntry);
                if (nonWorldEntry == this.organizableplayscreens_currentFolder) {
                    nbtEntry.method_10556("current", true);
                }
            }
            nbtEntry.method_10582("type", nonWorldEntry.getType().id().toString());
            nbtEntry.method_10582("name", nonWorldEntry.getName());
            nbtList.add((Object)nbtEntry);
        }
        for (class_528.class_4272 worldEntry : folder.getWorldEntries()) {
            nbtEntry = new class_2487();
            nbtEntry.method_10582("type", "minecraft:world");
            class_34 level = ((WorldEntryAccessor)worldEntry).getLevel();
            nbtEntry.method_10582("name", level.method_248());
            nbtEntry.method_10544("lastPlayed", level.method_249());
            nbtList.add((Object)nbtEntry);
        }
        class_2487 nbtCompound = new class_2487();
        nbtCompound.method_10566("entries", (class_2520)nbtList);
        return nbtCompound;
    }

    @Inject(method={"showSummaries"}, at={@At(value="HEAD")}, cancellable=true)
    private void organizableplayscreens_show(String search, List<class_34> summaries, CallbackInfo ci) {
        this.organizableplayscreens_updateEntries(search);
        ci.cancel();
    }

    @Override
    public void organizableplayscreens_swapEntries(int i, int j) {
        Collections.swap(this.organizableplayscreens_currentFolder.getNonWorldEntries(), i, j);
        this.organizableplayscreens_updateAndSave();
        this.method_20157((class_528.class_7414)this.method_25396().get(j));
        this.method_73377((class_350.class_351)((class_528.class_7414)this.method_25334()));
    }

    @Unique
    private void organizableplayscreens_updateEntries() {
        this.organizableplayscreens_updateEntries(this.field_39738);
    }

    @Unique
    private void organizableplayscreens_updateEntries(String search) {
        super.method_25339();
        if (search.isEmpty()) {
            Object worldEntry;
            SingleplayerFolderEntry folderEntry;
            class_350.class_351 class_3512 = this.method_25334();
            if (class_3512 instanceof class_528.class_4272 && (folderEntry = (SingleplayerFolderEntry)this.organizableplayscreens_worlds.get(worldEntry = (class_528.class_4272)class_3512)) != null) {
                this.organizableplayscreens_currentFolder = folderEntry;
                ((class_526)this.field_3237).method_19940(null);
            }
            this.organizableplayscreens_currentFolder.getNonWorldEntries().forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
            this.organizableplayscreens_currentFolder.getWorldEntries().forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        } else {
            search = search.toLowerCase(Locale.ROOT);
            for (class_528.class_4272 entry : this.organizableplayscreens_worlds.keySet()) {
                if (!this.method_43453(search, ((WorldEntryAccessor)entry).getLevel())) continue;
                this.method_25321((class_350.class_351)entry);
            }
        }
        class_528.class_7414 selected = (class_528.class_7414)this.method_25334();
        if (selected == null) {
            this.method_44382(0.0);
        } else {
            this.method_73377((class_350.class_351)selected);
        }
        this.method_43464();
    }

    @Override
    public void organizableplayscreens_updateCurrentPath() {
        SingleplayerFolderEntry folder;
        ArrayList<String> path = new ArrayList<String>();
        if (this.field_39738.isEmpty()) {
            folder = this.organizableplayscreens_currentFolder;
        } else {
            class_350.class_351 class_3512 = this.method_25334();
            if (class_3512 instanceof class_528.class_4272) {
                class_528.class_4272 worldEntry = (class_528.class_4272)class_3512;
                folder = (SingleplayerFolderEntry)this.organizableplayscreens_worlds.get(worldEntry);
            } else {
                this.organizableplayscreens_pathWidget.method_25355((class_2561)class_2561.method_43473());
                return;
            }
        }
        while (folder.getParent() != null) {
            path.add(folder.getName());
            folder = folder.getParent();
        }
        Collections.reverse(path);
        this.organizableplayscreens_pathWidget.method_25355(class_2561.method_30163((String)String.join((CharSequence)" > ", path)));
        ((SelectWorldScreenAccessor)this.field_3237).invokeRefreshWidgetPositions();
    }

    @Mixin(value={class_528.class_4272.class})
    public static interface WorldEntryAccessor {
        @Accessor
        public class_34 getLevel();
    }
}

