/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.config;

import dev.smootheez.scl.config.option.OptionList;
import dev.smootheez.scl.handler.BooleanWidgetHandler;
import dev.smootheez.scl.handler.CycleWidgetHandler;
import dev.smootheez.scl.handler.DoubleWidgetHandler;
import dev.smootheez.scl.handler.IntWidgetHandler;
import dev.smootheez.scl.handler.OptionListWidgetHandler;
import dev.smootheez.scl.handler.WidgetHandler;
import dev.smootheez.scl.registry.ConfigRegistry;
import dev.smootheez.scl.serializer.BooleanSerializer;
import dev.smootheez.scl.serializer.ConfigSerializer;
import dev.smootheez.scl.serializer.DoubleSerializer;
import dev.smootheez.scl.serializer.EnumSerializer;
import dev.smootheez.scl.serializer.IntegerSerializer;
import dev.smootheez.scl.serializer.OptionListSerializer;
import java.util.Arrays;

public class ConfigOption<T> {
    protected final String key;
    protected final T defaultValue;
    protected T value;
    protected T minValue;
    protected T maxValue;
    protected final Class<T> type;
    protected final ConfigSerializer<T> serializer;
    protected final WidgetHandler<T> widgetHandler;
    protected String translation;
    protected String configIdentifier;

    public ConfigOption(String key, T defaultValue, Class<T> type, ConfigSerializer<T> serializer, WidgetHandler<T> widgetHandler) {
        this.key = key;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.type = type;
        this.serializer = serializer;
        this.widgetHandler = widgetHandler;
    }

    public ConfigOption(String key, T defaultValue, Class<T> type, ConfigSerializer<T> serializer, WidgetHandler<T> widgetHandler, T minValue, T maxValue) {
        this.key = key;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.type = type;
        this.serializer = serializer;
        this.widgetHandler = widgetHandler;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public String getKey() {
        return this.key;
    }

    public void setConfigIdentifier(String configIdentifier) {
        this.configIdentifier = configIdentifier;
    }

    public String getTranslation() {
        this.translation = "options." + this.configIdentifier + "." + this.key;
        return this.translation;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public void setValue(T value) {
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value must be of type " + this.type.getSimpleName());
        }
        this.value = value;
        ConfigRegistry.save();
    }

    public Class<T> getType() {
        return this.type;
    }

    public WidgetHandler<T> getWidgetHandler() {
        return this.widgetHandler;
    }

    public ConfigSerializer<T> getSerializer() {
        return this.serializer;
    }

    public static ConfigOption<Boolean> create(String key, Boolean defaultValue) {
        return new ConfigOption<Boolean>(key, defaultValue, Boolean.class, new BooleanSerializer(), new BooleanWidgetHandler());
    }

    public static ConfigOption<OptionList> create(String key, String ... defaultValue) {
        return new ConfigOption<OptionList>(key, new OptionList(Arrays.asList(defaultValue)), OptionList.class, new OptionListSerializer(), new OptionListWidgetHandler());
    }

    public static ConfigOption<Integer> create(String key, Integer defaultValue, Integer minValue, Integer maxValue) {
        return new ConfigOption<Integer>(key, defaultValue, Integer.class, new IntegerSerializer(), new IntWidgetHandler(), minValue, maxValue);
    }

    public static ConfigOption<Double> create(String key, Double defaultValue, Double minValue, Double maxValue) {
        return new ConfigOption<Double>(key, defaultValue, Double.class, new DoubleSerializer(), new DoubleWidgetHandler(), minValue, maxValue);
    }

    public static <E extends Enum<E>> ConfigOption<E> create(String key, E defaultValue) {
        Class<?> clazz = defaultValue.getClass();
        return new ConfigOption<E>(key, defaultValue, clazz, new EnumSerializer(clazz), new CycleWidgetHandler());
    }
}

