/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.smootheez.scl.config.ConfigOption;
import dev.smootheez.scl.file.ConfigOptionAdapter;
import dev.smootheez.scl.registry.ConfigRegistry;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigFileWriter {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile;
    private final Map<String, ConfigOptionAdapter<?>> adapterMap = new TreeMap();

    public ConfigFileWriter(String configIdentifier) {
        this.configFile = FabricLoader.getInstance().getConfigDir().resolve(configIdentifier + ".json").toFile();
        HashSet<String> usedKeys = new HashSet<String>();
        List<ConfigOption<?>> configOptions = ConfigRegistry.getConfigOptions(configIdentifier);
        for (ConfigOption<?> option : configOptions) {
            String key = option.getKey();
            if (usedKeys.contains(key)) {
                throw new IllegalStateException("Duplicate key found: " + key);
            }
            usedKeys.add(key);
            this.adapterMap.put(key, this.createAdapter(option));
        }
    }

    public void loadConfig() {
        if (!this.configFile.exists()) {
            this.saveConfig();
            return;
        }
        try (FileReader reader = new FileReader(this.configFile);){
            JsonObject jsonObject = (JsonObject)this.gson.fromJson((Reader)reader, JsonObject.class);
            this.fromJson(jsonObject);
        }
        catch (IOException e) {
            throw new RuntimeException("Error load config ", e);
        }
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            JsonObject object = this.toJson();
            this.gson.toJson((JsonElement)object, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Error saving config ", e);
        }
    }

    private void fromJson(JsonObject jsonObject) {
        this.adapterMap.forEach((key, adapter) -> {
            if (jsonObject.has(key)) {
                adapter.fromJson(jsonObject.get(key));
            }
        });
    }

    private JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        this.adapterMap.forEach((key, adapter) -> jsonObject.add(key, adapter.toJson()));
        return jsonObject;
    }

    private <T> ConfigOptionAdapter<T> createAdapter(ConfigOption<T> option) {
        return new ConfigOptionAdapter<T>(option);
    }
}

