/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.registry;

import dev.smootheez.scl.annotation.Config;
import dev.smootheez.scl.api.ConfigProvider;
import dev.smootheez.scl.config.ConfigOption;
import dev.smootheez.scl.file.ConfigFileWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigRegistry {
    private static final Map<String, List<ConfigOption<?>>> configOptionsMap = new HashMap();
    private static final Set<String> usedConfigIdentifiers = new HashSet<String>();
    private static final Map<String, ConfigFileWriter> configWriters = new HashMap<String, ConfigFileWriter>();

    public static void registerConfig(Class<? extends ConfigProvider> config) {
        String configIdentifier;
        if (config.getAnnotation(Config.class) != null) {
            configIdentifier = config.getAnnotation(Config.class).value();
            if (usedConfigIdentifiers.contains(configIdentifier)) {
                throw new IllegalArgumentException("Config identifier '" + configIdentifier + "' is already in use.");
            }
            usedConfigIdentifiers.add(configIdentifier);
            try {
                List<Field> configFields = ConfigRegistry.getConfigFields(config);
                ArrayList<ConfigOption> options = new ArrayList<ConfigOption>();
                for (Field field : configFields) {
                    field.setAccessible(true);
                    ConfigOption option = (ConfigOption)field.get(config);
                    option.setConfigIdentifier(configIdentifier);
                    options.add(option);
                }
                configOptionsMap.put(configIdentifier, options);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new IllegalArgumentException("ConfigFileWriter must be annotated with @Config");
        }
        ConfigFileWriter fileWriter = new ConfigFileWriter(configIdentifier);
        configWriters.put(configIdentifier, fileWriter);
        fileWriter.loadConfig();
    }

    public static void save() {
        for (ConfigFileWriter writer : configWriters.values()) {
            writer.saveConfig();
        }
    }

    private static List<Field> getConfigFields(Class<?> clazz) {
        ArrayList<Field> configFields = new ArrayList<Field>();
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getType().equals(ConfigOption.class)) continue;
            configFields.add(field);
        }
        return configFields;
    }

    public static List<ConfigOption<?>> getConfigOptions(String configIdentifier) {
        return configOptionsMap.getOrDefault(configIdentifier, new ArrayList());
    }
}

