/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.widget;

import com.google.common.collect.ImmutableList;
import dev.smootheez.scl.config.ConfigOption;
import dev.smootheez.scl.registry.ConfigRegistry;
import dev.smootheez.scl.widget.AbstractConfigWidget;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class ConfigListWidget
extends class_4265<AbstractConfigWidget> {
    private String filter = "";
    private final String configIdentifier;

    public ConfigListWidget(class_310 minecraftClient, int width, int height, int v1, int v2, int entryHeight, String configIdentifier) {
        super(minecraftClient, width, height, v1, v2, entryHeight);
        this.configIdentifier = configIdentifier;
        this.updateEntries();
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase();
        this.updateEntries();
    }

    private void updateEntries() {
        this.method_25339();
        List<ConfigOption<?>> configOptions = ConfigRegistry.getConfigOptions(this.configIdentifier);
        List<ConfigOption> filteredOptions = configOptions.stream().filter(configOption -> this.matchesSearchTerm((ConfigOption<?>)configOption, this.filter)).toList();
        for (ConfigOption option : filteredOptions) {
            this.method_25321((class_350.class_351)this.createWidget(option));
        }
    }

    private boolean matchesSearchTerm(ConfigOption<?> option, String searchTerm) {
        String lowercaseSearchTerm = searchTerm.toLowerCase();
        String translation = option.getTranslation();
        String translatedText = class_2561.method_43471((String)translation).getString();
        return translatedText.toLowerCase().contains(lowercaseSearchTerm) || option.getKey().toLowerCase().contains(lowercaseSearchTerm);
    }

    public <T> AbstractConfigWidget createWidget(ConfigOption<T> option) {
        List<class_5481> description = this.createDescriptionText(option);
        return option.getWidgetHandler().createWidget(option, description);
    }

    private List<class_5481> createDescriptionText(ConfigOption<?> option) {
        String descriptionKey = option.getTranslation() + ".description";
        class_5250 descriptionText = class_2561.method_43471((String)descriptionKey);
        if (class_1074.method_4663((String)descriptionKey)) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)class_2561.method_43470((String)option.getKey()).method_27692(class_124.field_1054).method_30937());
            this.field_22740.field_1772.method_1728((class_5348)descriptionText, 200).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            return builder.build();
        }
        return ImmutableList.of((Object)class_2561.method_43470((String)option.getKey()).method_27692(class_124.field_1054).method_30937());
    }

    protected int method_25329() {
        return this.field_22742 / 2 + 185;
    }

    public int method_25322() {
        return 350;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        AbstractConfigWidget abstractConfigWidget = (AbstractConfigWidget)this.method_37019();
        if (abstractConfigWidget != null && abstractConfigWidget.description != null && this.field_22740.field_1755 != null) {
            this.field_22740.field_1755.method_47414(abstractConfigWidget.description);
        }
    }
}

