/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.widget.entry;

import dev.smootheez.scl.config.ConfigOption;
import dev.smootheez.scl.helper.ConfigWidgetHelper;
import dev.smootheez.scl.util.ValidateConfigValue;
import dev.smootheez.scl.widget.NamedConfigWidget;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class DoubleConfigEntries
extends NamedConfigWidget {
    private final class_342 textFieldWidget;
    private final class_4185 resetButton;
    private final ConfigOption<Double> option;

    public DoubleConfigEntries(class_2561 name, @Nullable List<class_5481> description, ConfigOption<Double> option) {
        super(name, description);
        this.option = option;
        this.textFieldWidget = ConfigWidgetHelper.createTextFieldWidget(name);
        this.textFieldWidget.method_1852(Double.toString(option.getValue()));
        this.textFieldWidget.method_1863(this::onTextChanged);
        this.resetButton = ConfigWidgetHelper.createResetButton(this::resetValue);
        this.children.add(this.textFieldWidget);
        this.children.add(this.resetButton);
        this.updateResetButtonState();
    }

    private void resetValue() {
        double defaultValue = this.option.getDefaultValue();
        this.textFieldWidget.method_1852(Double.toString(defaultValue));
        this.option.setValue(defaultValue);
        this.textFieldWidget.method_1868(0xE0E0E0);
        this.updateResetButtonState();
    }

    private void onTextChanged(String value) {
        if (ValidateConfigValue.validateDoubleValue(value) && Double.parseDouble(value) >= this.option.getMinValue() && Double.parseDouble(value) <= this.option.getMaxValue()) {
            this.textFieldWidget.method_1868(0xE0E0E0);
            this.option.setValue(Double.valueOf(value));
        } else {
            this.textFieldWidget.method_1868(0xFF0000);
        }
        this.updateResetButtonState();
    }

    private void updateResetButtonState() {
        double defaultValue;
        double currentValue = this.option.getValue();
        this.resetButton.field_22763 = currentValue != (defaultValue = this.option.getDefaultValue().doubleValue());
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(context, x, y);
        this.textFieldWidget.method_46421(x + entryWidth - 103);
        this.textFieldWidget.method_46419(y + 2);
        this.textFieldWidget.method_25394(context, mouseX, mouseY, tickDelta);
        ConfigWidgetHelper.setResetButtonPosition(this.resetButton, context, x, y, entryWidth, mouseX, mouseY, tickDelta);
    }
}

