/*
 * Decompiled with CFR 0.152.
 */
package dev.smootheez.scl.widget.entry;

import dev.smootheez.scl.config.ConfigOption;
import dev.smootheez.scl.helper.ConfigWidgetHelper;
import dev.smootheez.scl.util.ValidateConfigValue;
import dev.smootheez.scl.widget.NamedConfigWidget;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;

public class IntConfigEntries
extends NamedConfigWidget {
    private final class_342 textFieldWidget;
    private final class_4185 resetButton;
    private final ConfigOption<Integer> option;

    public IntConfigEntries(class_2561 name, @Nullable List<class_5481> description, ConfigOption<Integer> option) {
        super(name, description);
        this.option = option;
        this.textFieldWidget = ConfigWidgetHelper.createTextFieldWidget(name);
        this.textFieldWidget.method_1852(Integer.toString(option.getValue()));
        this.textFieldWidget.method_1863(this::onTextChanged);
        this.resetButton = ConfigWidgetHelper.createResetButton(this::resetValue);
        this.children.add(this.textFieldWidget);
        this.children.add(this.resetButton);
        this.updateResetButtonState();
    }

    private void onTextChanged(String value) {
        if (ValidateConfigValue.validateIntValue(value) && Integer.parseInt(value) >= this.option.getMinValue() && Integer.parseInt(value) <= this.option.getMaxValue()) {
            this.textFieldWidget.method_1868(0xE0E0E0);
            this.option.setValue(Integer.valueOf(value));
        } else {
            this.textFieldWidget.method_1868(0xFF0000);
        }
        this.updateResetButtonState();
    }

    private void resetValue() {
        int defaultValue = this.option.getDefaultValue();
        this.textFieldWidget.method_1852(Integer.toString(defaultValue));
        this.option.setValue(defaultValue);
        this.textFieldWidget.method_1868(0xE0E0E0);
        this.updateResetButtonState();
    }

    private void updateResetButtonState() {
        int defaultValue;
        int currentValue = this.option.getValue();
        this.resetButton.field_22763 = currentValue != (defaultValue = this.option.getDefaultValue().intValue());
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        this.drawName(context, x, y);
        this.textFieldWidget.method_46421(x + entryWidth - 103);
        this.textFieldWidget.method_46419(y + 2);
        this.textFieldWidget.method_25394(context, mouseX, mouseY, tickDelta);
        ConfigWidgetHelper.setResetButtonPosition(this.resetButton, context, x, y, entryWidth, mouseX, mouseY, tickDelta);
    }
}

