/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer;

import com.ave.simplestationsminer.WorkMode;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="simplestationsminer", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static ForgeConfigSpec SPEC;
    public static ForgeConfigSpec.IntValue ENERGY_PER_TICK;
    public static ForgeConfigSpec.IntValue MAX_PROGRESS;
    public static ForgeConfigSpec.IntValue MAX_COOLANT;
    public static ForgeConfigSpec.IntValue MAX_CATALYST;
    public static ForgeConfigSpec.IntValue FUEL_PER_COAL;
    public static ForgeConfigSpec.IntValue FUEL_CAPACITY;
    public static ForgeConfigSpec.IntValue MAX_Y;
    public static ForgeConfigSpec.EnumValue<WorkMode> WORK_MODE;

    public static boolean isExtendedMod() {
        return WORK_MODE.get() == WorkMode.Extended;
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent event) {
    }

    static {
        ENERGY_PER_TICK = BUILDER.comment("How much RF to consume per tick\n Default: 16").defineInRange("consume", 16, 1, 1000);
        MAX_PROGRESS = BUILDER.comment("Default working time in ticks\n Default: 1000").defineInRange("work_time", 1000, 1, 100000);
        MAX_COOLANT = BUILDER.comment("Max coolant to store\n Default: 20").defineInRange("max_coolant", 20, 1, 10000);
        MAX_CATALYST = BUILDER.comment("Max catalyst to store\n Default: 20").defineInRange("max_catalyst", 20, 1, 10000);
        FUEL_PER_COAL = BUILDER.comment("Base RF amount received from 1 coal\n Default: 48000").defineInRange("fuel_rf", 48000, 1, 1000000);
        FUEL_CAPACITY = BUILDER.comment("How much RF can be stored\n Default: 480000").defineInRange("fuel_max", 480000, 1, 2000000000);
        MAX_Y = BUILDER.comment("Highest Y for miner\n Default: 20").defineInRange("max_y", 20, -1000, 1000);
        WORK_MODE = BUILDER.comment("Extended work mode forces catalyst and coolant usage\n Default: Basic").defineEnum("work_mode", (Enum)WorkMode.Extended, (Enum[])new WorkMode[]{WorkMode.Basic, WorkMode.Extended});
        SPEC = BUILDER.build();
    }
}

