/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity;

import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.partblock.PartBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class MinerBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public MinerBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MinerBlockEntity(pos, state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (lvl, pos, st, be) -> {
            if (be instanceof MinerBlockEntity) {
                MinerBlockEntity miner = (MinerBlockEntity)be;
                miner.tick();
            }
        };
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player instanceof ServerPlayer)) {
            return ItemInteractionResult.SUCCESS;
        }
        ServerPlayer sp = (ServerPlayer)player;
        MinerBlockEntity blockEntity = (MinerBlockEntity)level.getBlockEntity(pos);
        sp.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity, (Component)Component.literal((String)"")), pos);
        return ItemInteractionResult.SUCCESS;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Level lvl;
        if (level instanceof Level && (lvl = (Level)level).dimension().equals((Object)Level.NETHER)) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos) || level.getBlockState(p).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        if (level.isClientSide) {
            return;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos)) continue;
                BlockState block = ((Block)SimpleStationsMiner.MINER_PART.get()).defaultBlockState();
                level.setBlock(p, block, 3);
                PartBlockEntity be = (PartBlockEntity)level.getBlockEntity(p);
                be.setControllerPos(pos);
            }
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity controller = level.getBlockEntity(pos);
        if (controller instanceof MinerBlockEntity) {
            MinerBlockEntity miner = (MinerBlockEntity)controller;
            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)SimpleStationsMiner.MINER_BLOCK_ITEM.get(), 1));
            Containers.dropContents((Level)level, (BlockPos)pos, miner.inventory.getAsList());
        }
        super.onRemove(state, level, pos, newState, moving);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                BlockEntity be;
                BlockPos p = pos.offset(dx, 0, dz);
                if (p.equals((Object)pos) || !((be = level.getBlockEntity(p)) instanceof PartBlockEntity)) continue;
                level.destroyBlock(p, false);
            }
        }
    }
}

