/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.blockentity.ModBlockEntities;
import com.ave.simplestationsminer.blockentity.ModContainer;
import com.ave.simplestationsminer.blockentity.UpgradeType;
import com.ave.simplestationsminer.blockentity.handlers.InputItemHandler;
import com.ave.simplestationsminer.blockentity.handlers.OutputItemHandler;
import com.ave.simplestationsminer.blockentity.managers.ExportManager;
import com.ave.simplestationsminer.blockentity.managers.ResourceManager;
import com.ave.simplestationsminer.blockentity.managers.UpgradeManager;
import com.ave.simplestationsminer.blockentity.managers.WorkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class MinerBlockEntity
extends ModContainer {
    public EnergyStorage fuel;
    public int fuelHigh = 0;
    public int fuelLow = 0;
    public Item type = null;
    public float progress = 0.0f;
    public int coolant = 0;
    public int redstone = 0;
    public boolean working = false;
    public boolean invalidDepth = false;
    public List<UpgradeType> upgrades = new ArrayList<UpgradeType>();
    public boolean hasNetherUpdate = false;
    public Item drill = null;
    public int drillCount = 0;
    public float speed = 1.0f;
    public int outputSize = 1;
    public int powerConsuption = 0;
    public int upgradesHash = 0;
    public int soundCooldown = 0;
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.fuel);
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> new OutputItemHandler(this.inventory));
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> new InputItemHandler(this.inventory));

    public MinerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<MinerBlockEntity>)((BlockEntityType)ModBlockEntities.MINER_BLOCK_ENTITY.get()), pos, state, 7);
        if (pos != null) {
            this.invalidDepth = pos.getY() > (Integer)Config.MAX_Y.get();
        }
        this.fuel = new EnergyStorage(((Integer)Config.FUEL_CAPACITY.get()).intValue());
    }

    public void tick() {
        if (this.level.isClientSide || this.invalidDepth) {
            return;
        }
        if (this.progress >= (float)((Integer)Config.MAX_PROGRESS.get()).intValue()) {
            this.progress -= (float)((Integer)Config.MAX_PROGRESS.get()).intValue();
        }
        boolean shouldUpdate = this.checkNewType() || UpgradeManager.checkUpgradeSlots(this);
        ResourceManager.checkAllResources(this);
        this.working = WorkManager.getWorking(this);
        if (shouldUpdate) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
        ExportManager.pushOutput(this);
        this.fuelHigh = this.fuel.getEnergyStored() >> 16;
        this.fuelLow = this.fuel.getEnergyStored() & 0xFFFF;
        if (this.type == null || !this.working) {
            return;
        }
        WorkManager.performWorkTick(this);
        if (this.progress < (float)((Integer)Config.MAX_PROGRESS.get()).intValue()) {
            return;
        }
        WorkManager.performWorkEnd(this);
        this.setChanged();
    }

    private boolean checkNewType() {
        Item newType = this.getCurrentFilter();
        if (this.type == null && newType == null || this.type != null && this.type.equals(newType)) {
            return false;
        }
        this.type = newType;
        this.progress = 0.0f;
        this.speed = WorkManager.getSpeedValue(this);
        this.outputSize = WorkManager.getOutputSize(this.type);
        return true;
    }

    public boolean isValidWorld() {
        if (this.type == null || this.hasNetherUpdate) {
            return true;
        }
        return !this.type.toString().contains("nether");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return side.equals((Object)Direction.DOWN) ? this.outputHandler.cast() : this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveAll(tag);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.saveAll(tag);
    }

    @Override
    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.type = this.getCurrentFilter();
        this.fuel = new EnergyStorage(((Integer)Config.FUEL_CAPACITY.get()).intValue(), ((Integer)Config.FUEL_CAPACITY.get()).intValue(), ((Integer)Config.FUEL_CAPACITY.get()).intValue(), tag.getInt("fuel"));
        this.progress = tag.getFloat("progress");
        this.coolant = tag.getInt("coolant");
        this.redstone = tag.getInt("redstone");
        this.upgrades.clear();
        this.outputSize = WorkManager.getOutputSize(this.type);
        for (byte up : tag.getByteArray("upgrades")) {
            this.upgrades.add(UpgradeType.values()[up]);
        }
        UpgradeManager.applyUpgrades(this);
        this.speed = WorkManager.getSpeedValue(this);
    }

    private void saveAll(CompoundTag tag) {
        tag.putInt("fuel", this.fuel.getEnergyStored());
        tag.putFloat("progress", this.progress);
        tag.putInt("coolant", this.coolant);
        tag.putInt("redstone", this.redstone);
        tag.putByteArray("upgrades", this.upgrades.stream().map(x -> (byte)x.ordinal()).toList());
    }

    private Item getCurrentFilter() {
        ItemStack stack = this.inventory.getStackInSlot(2);
        return stack.isEmpty() ? null : stack.getItem();
    }
}

