/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity;

import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.handlers.InputItemHandler;
import com.ave.simplestationsminer.blockentity.handlers.OutputItemHandler;
import com.ave.simplestationsminer.blockentity.handlers.SidedItemHandler;
import com.ave.simplestationsminer.screen.MinerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;

public class ModContainer
extends BlockEntity
implements MenuProvider {
    public final SidedItemHandler inventory;
    public static final int OUTPUT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int TYPE_SLOT = 2;
    public static final int COOLANT_SLOT = 3;
    public static final int REDSTONE_SLOT = 4;
    public static final int PORTAL_SLOT = 5;
    public static final int DRILL_SLOT = 6;
    private static final int SIZE = 7;

    public ModContainer(BlockEntityType<MinerBlockEntity> entity, BlockPos pos, BlockState state, int size) {
        super(entity, pos, state);
        this.inventory = new SidedItemHandler(size){

            protected void onContentsChanged(int slot) {
                ModContainer.this.setChanged();
            }
        };
    }

    public IItemHandler getItemHandler(Direction side) {
        if (side == Direction.DOWN) {
            return new OutputItemHandler(this.inventory);
        }
        return new InputItemHandler(this.inventory);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.simplestationsminer.miner");
    }

    public AbstractContainerMenu createMenu(int containerId, Inventory inventory, Player player) {
        return new MinerMenu(containerId, inventory, this);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("inventory", (Tag)this.inventory.serializeNBT(registries));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag.getCompound("inventory"));
        if (this.inventory.getSlots() != 7) {
            this.inventory.setSize(7);
            this.inventory.setStackInSlot(6, new ItemStack((ItemLike)SimpleStationsMiner.DRILL_ITEM.get(), 2));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

