/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity.managers;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ResourceManager {
    public static void checkAllResources(MinerBlockEntity miner) {
        ResourceManager.checkResource(miner, 1, Items.COAL_BLOCK, (Integer)Config.FUEL_PER_COAL.get(), (Integer)Config.FUEL_CAPACITY.get(), ResourceType.FUEL);
        if (Config.isExtendedMod()) {
            ResourceManager.checkResource(miner, 4, Items.REDSTONE_BLOCK, 1, (Integer)Config.MAX_CATALYST.get(), ResourceType.REDSTONE);
            ResourceManager.checkResource(miner, 3, Items.LAPIS_BLOCK, 1, (Integer)Config.MAX_COOLANT.get(), ResourceType.COOLANT);
        }
    }

    private static void checkResource(MinerBlockEntity miner, int slot, Item blockItem, int singleValue, int maxCapacity, ResourceType type) {
        int increment;
        ItemStack stack = miner.inventory.getStackInSlot(slot);
        int n = increment = stack.getItem().equals(blockItem) ? singleValue * 9 : singleValue;
        if (stack.isEmpty() || ResourceManager.getResourceValue(miner, type) + increment > maxCapacity) {
            return;
        }
        stack.shrink(1);
        miner.inventory.setStackInSlot(slot, stack);
        ResourceManager.addResource(miner, type, increment);
    }

    private static void addResource(MinerBlockEntity miner, ResourceType type, int amount) {
        switch (type.ordinal()) {
            case 0: {
                miner.fuel.receiveEnergy(amount, false);
                break;
            }
            case 1: {
                miner.coolant += amount;
                break;
            }
            case 2: {
                miner.redstone += amount;
            }
        }
    }

    private static int getResourceValue(MinerBlockEntity miner, ResourceType type) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> miner.fuel.getEnergyStored();
            case 1 -> miner.coolant;
            case 2 -> miner.redstone;
        };
    }

    private static enum ResourceType {
        FUEL,
        COOLANT,
        REDSTONE;

    }
}

