/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity.managers;

import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.UpgradeType;
import com.ave.simplestationsminer.blockentity.managers.WorkManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UpgradeManager {
    public static boolean checkUpgradeSlots(MinerBlockEntity miner) {
        List<UpgradeType> newUpgrades = UpgradeManager.getUpgradeList(miner);
        int newHash = UpgradeManager.getUpgradesHash(newUpgrades);
        if (newHash == miner.upgradesHash) {
            return false;
        }
        miner.upgrades = newUpgrades;
        UpgradeManager.applyUpgrades(miner);
        miner.speed = WorkManager.getSpeedValue(miner);
        return true;
    }

    private static List<UpgradeType> getUpgradeList(MinerBlockEntity miner) {
        ItemStack drillSlot;
        ArrayList<UpgradeType> list = new ArrayList<UpgradeType>();
        ItemStack portalSlot = miner.inventory.getStackInSlot(5);
        if (portalSlot.getCount() > 0) {
            list.add(UpgradeType.Portal);
        }
        if ((drillSlot = miner.inventory.getStackInSlot(6)).getCount() > 0) {
            UpgradeType type = UpgradeType.getFromItem(drillSlot.getItem());
            for (int i = 0; i < drillSlot.getCount(); ++i) {
                list.add(type);
            }
        }
        return list;
    }

    public static void applyUpgrades(MinerBlockEntity miner) {
        miner.hasNetherUpdate = false;
        miner.drill = null;
        miner.drillCount = 0;
        for (UpgradeType up : miner.upgrades) {
            if (up.equals((Object)UpgradeType.Portal)) {
                miner.hasNetherUpdate = true;
                continue;
            }
            ++miner.drillCount;
            miner.drill = up.item;
        }
        miner.upgradesHash = UpgradeManager.getUpgradesHash(miner.upgrades);
        miner.powerConsuption = UpgradeManager.getPowerConsumption(miner.drill);
    }

    private static int getUpgradesHash(List<UpgradeType> list) {
        int hash = 0;
        for (UpgradeType up : list) {
            hash *= 31;
            hash += up.ordinal();
        }
        return hash;
    }

    private static int getPowerConsumption(Item drill) {
        if (drill == null) {
            return 0;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM.get())) {
            return 1;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM_2.get())) {
            return 2;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM_3.get())) {
            return 4;
        }
        return 0;
    }

    public static float getSpeedPerDrill(Item drill) {
        if (drill == null) {
            return 0.0f;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM.get())) {
            return 0.5f;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM_2.get())) {
            return 0.9f;
        }
        if (drill.equals(SimpleStationsMiner.DRILL_ITEM_3.get())) {
            return 1.5f;
        }
        return 0.0f;
    }
}

