/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity.partblock;

import com.ave.simplestationsminer.blockentity.MinerBlock;
import com.ave.simplestationsminer.blockentity.partblock.PartBlockEntity;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class PartBlock
extends Block
implements EntityBlock {
    public static final MapCodec<BlockPos> CONTROLLER_POS_CODEC = BlockPos.CODEC.fieldOf("controller");

    public PartBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PartBlockEntity(pos, state);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof PartBlockEntity)) {
            return ItemInteractionResult.SUCCESS;
        }
        PartBlockEntity part = (PartBlockEntity)be;
        BlockPos ctrlPos = part.getControllerPos();
        MinerBlock ctrl = (MinerBlock)level.getBlockState(ctrlPos).getBlock();
        ctrl.useItemOn(stack, state, level, ctrlPos, player, hand, hit);
        return ItemInteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof PartBlockEntity)) {
            return;
        }
        PartBlockEntity part = (PartBlockEntity)be;
        super.onRemove(state, level, pos, newState, moved);
        if (state.getBlock() == newState.getBlock()) {
            return;
        }
        BlockPos controllerPos = part.getControllerPos();
        BlockState controllerState = level.getBlockState(controllerPos);
        if (controllerState.getBlock() instanceof MinerBlock) {
            level.destroyBlock(controllerPos, true);
        }
    }
}

