/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.blockentity.partblock;

import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.ModBlockEntities;
import com.ave.simplestationsminer.blockentity.handlers.InputItemHandler;
import com.ave.simplestationsminer.blockentity.handlers.OutputItemHandler;
import com.ave.simplestationsminer.blockentity.handlers.SidedItemHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;

public class PartBlockEntity
extends BlockEntity {
    private final LazyOptional<IEnergyStorage> energy = LazyOptional.of(() -> this.getEnergyStorage(this));
    private final LazyOptional<IItemHandler> outputHandler = LazyOptional.of(() -> this.getItemHandler(Direction.DOWN, this));
    private final LazyOptional<IItemHandler> inputHandler = LazyOptional.of(() -> this.getItemHandler(Direction.UP, this));
    private BlockPos controllerPos;

    public PartBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.PART_BLOCK_ENTITY.get(), pos, state);
    }

    public void setControllerPos(BlockPos pos) {
        this.controllerPos = pos;
        this.setChanged();
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energy.cast();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return side.equals((Object)Direction.DOWN) ? this.outputHandler.cast() : this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public IItemHandler getItemHandler(Direction side, PartBlockEntity be) {
        SidedItemHandler inventory = ((MinerBlockEntity)be.getLevel().getBlockEntity((BlockPos)be.controllerPos)).inventory;
        if (side == Direction.DOWN) {
            return new OutputItemHandler(inventory);
        }
        return new InputItemHandler(inventory);
    }

    public EnergyStorage getEnergyStorage(PartBlockEntity be) {
        return ((MinerBlockEntity)be.getLevel().getBlockEntity((BlockPos)be.controllerPos)).fuel;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.controllerPos == null) {
            return;
        }
        tag.putLong("Controller", this.controllerPos.asLong());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.controllerPos = BlockPos.of((long)tag.getLong("Controller"));
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

