/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.recipes;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.blockentity.managers.WorkManager;
import com.ave.simplestationsminer.datagen.ModTags;
import com.ave.simplestationsminer.recipes.MinerRecipeCategory;
import com.ave.simplestationsminer.recipes.SimpleRecipe;
import com.ave.simplestationsminer.screen.MinerScreen;
import com.ave.simplestationsminer.uihelpers.UIBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIModPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new MinerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList recipes = Lists.newArrayList();
        for (Holder item : BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.Items.MINEABLE_TAG)) {
            ItemStack stack = new ItemStack(item);
            int consume = (Integer)Config.ENERGY_PER_TICK.get() * (Integer)Config.MAX_PROGRESS.get() * WorkManager.getSpeedMod((Item)item.value());
            recipes.add(new SimpleRecipe(consume, stack, WorkManager.getOutputSize((Item)item.value())));
        }
        registration.addRecipes(MinerRecipeCategory.REGULAR, (List)recipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)SimpleStationsMiner.MINER_BLOCK.get()), new RecipeType[]{MinerRecipeCategory.REGULAR});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(MinerScreen.class, UIBlocks.OUT_SLOT.left - 16, 6, UIBlocks.OUT_SLOT.width + 32, UIBlocks.OUT_SLOT.height, new RecipeType[]{MinerRecipeCategory.REGULAR});
    }
}

