/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.recipes;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.recipes.SimpleRecipe;
import com.ave.simplestationsminer.uihelpers.UIBlocks;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MinerRecipeCategory
implements IRecipeCategory<SimpleRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"regular");
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"textures/gui/jei.png");
    private static final ResourceLocation TEXTURE_MIN = ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"textures/gui/jei_min.png");
    public IGuiHelper guiHelper;
    public static RecipeType<SimpleRecipe> REGULAR = RecipeType.create((String)"simplestationsminer", (String)"regular", SimpleRecipe.class);
    private final IDrawableStatic bg;
    private final IDrawableStatic bg_min;

    public MinerRecipeCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.bg = guiHelper.createDrawable(TEXTURE, 0, 0, 176, 80);
        this.bg_min = guiHelper.createDrawable(TEXTURE_MIN, 0, 0, 176, 80);
    }

    public RecipeType<SimpleRecipe> getRecipeType() {
        return REGULAR;
    }

    public Component getTitle() {
        return Component.translatable((String)"screen.simplestationsminer.recipes");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)SimpleStationsMiner.MINER_BLOCK_ITEM.get()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SimpleRecipe recipe, IFocusGroup focuses) {
        if (Config.isExtendedMod()) {
            builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.CATA_SLOT.left, UIBlocks.CATA_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.REDSTONE}));
            builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.COOL_SLOT.left, UIBlocks.COOL_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.LAPIS_LAZULI}));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, UIBlocks.FUEL_SLOT.left, UIBlocks.FUEL_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL}));
        builder.addSlot(RecipeIngredientRole.OUTPUT, UIBlocks.OUT_SLOT.left, UIBlocks.OUT_SLOT.top).addItemStack(new ItemStack((ItemLike)recipe.filter.getItem(), recipe.output));
        builder.addSlot(RecipeIngredientRole.CATALYST, UIBlocks.FILTER_SLOT.left, UIBlocks.FILTER_SLOT.top).addIngredients(Ingredient.of((ItemLike[])new ItemLike[]{recipe.filter.getItem()}));
    }

    public IDrawable getBackground() {
        return Config.isExtendedMod() ? this.bg : this.bg_min;
    }

    public List<Component> getTooltipStrings(SimpleRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList list = Lists.newArrayList();
        if (UIBlocks.FUEL_BAR.isHovered(mouseX, mouseY)) {
            list.add(Component.literal((String)(recipe.energy + " RF")));
        }
        return list;
    }
}

