/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.renderer;

import com.ave.simplestationsminer.blockentity.MinerBlock;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.Property;

public class MinerRenderer
implements BlockEntityRenderer<MinerBlockEntity> {
    public MinerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(MinerBlockEntity be, float pt, PoseStack pose, MultiBufferSource buf, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        if (be.type == null) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)be.type);
        Direction direction = (Direction)be.getBlockState().getValue((Property)MinerBlock.FACING);
        long gameTime = be.getLevel().getGameTime();
        this.drawBlock(pose, itemRenderer, stack, be, buf, this.getZShift(gameTime, 0), 0.5f, direction, 0.7f, 0.0f);
        this.drawBlock(pose, itemRenderer, stack, be, buf, this.getZShift(gameTime, 250), 0.4f, direction, 0.7f, 0.0f);
        this.drawBlock(pose, itemRenderer, stack, be, buf, this.getZShift(gameTime, 500), 0.5f, direction, 0.7f, 0.0f);
        this.drawBlock(pose, itemRenderer, stack, be, buf, this.getZShift(gameTime, 750), 0.6f, direction, 0.7f, 0.0f);
        float rotation = gameTime * 4L % 360L;
        if (be.drill != null) {
            ItemStack drill = new ItemStack((ItemLike)be.drill);
            if (be.drillCount > 0) {
                this.drawBlock(pose, itemRenderer, drill, be, buf, -0.5f, -0.5f, direction, 1.0f, rotation);
            }
            if (be.drillCount > 1) {
                this.drawBlock(pose, itemRenderer, drill, be, buf, -0.5f, 1.5f, direction, 1.0f, rotation);
            }
        }
    }

    private float getZShift(long gameTime, int delay) {
        float shift = (float)((gameTime + (long)delay) % 1000L) / 200.0f - 0.5f;
        return Math.clamp(shift, -0.5f, 1.5f);
    }

    private void drawBlock(PoseStack pose, ItemRenderer itemRenderer, ItemStack stack, MinerBlockEntity be, MultiBufferSource buf, float sx, float sz, Direction direction, float size, float rotate) {
        if (sx >= 1.5f || sx < -0.5f) {
            return;
        }
        if (direction == Direction.WEST || direction == Direction.SOUTH) {
            sx = 1.0f - sx;
        }
        if (direction == Direction.EAST || direction == Direction.WEST) {
            float temp = sx;
            sx = sz;
            sz = temp;
        }
        pose.pushPose();
        pose.translate(sx, 0.5f, sz);
        pose.scale(0.7f, size, 0.7f);
        if (rotate > 0.0f) {
            pose.mulPose(Axis.YP.rotationDegrees(rotate));
        }
        int light = this.getLightLevel(be.getLevel(), be.getBlockPos());
        itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, pose, buf, be.getLevel(), 1);
        pose.popPose();
    }

    private int getLightLevel(Level level, BlockPos pos) {
        int bLight = level.getBrightness(LightLayer.BLOCK, pos);
        int sLight = level.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)sLight);
    }
}

