/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.screen;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.SimpleStationsMiner;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.ModContainer;
import com.ave.simplestationsminer.screen.ModMenuTypes;
import com.ave.simplestationsminer.uihelpers.UIBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class MinerMenu
extends AbstractContainerMenu {
    public final Level level;
    public final ModContainer blockEntity;

    public MinerMenu(int containerId, Inventory inventory, FriendlyByteBuf data) {
        this(containerId, inventory, (ModContainer)inventory.player.level().getBlockEntity(data.readBlockPos()));
    }

    public MinerMenu(int containerId, Inventory inventory, ModContainer be) {
        super((MenuType)ModMenuTypes.MINER_MENU.get(), containerId);
        ModContainer modContainer;
        this.level = inventory.player.level();
        this.blockEntity = be;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 0, UIBlocks.OUT_SLOT.left, UIBlocks.OUT_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 1, UIBlocks.FUEL_SLOT.left, UIBlocks.FUEL_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 2, UIBlocks.FILTER_SLOT.left, UIBlocks.FILTER_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 5, UIBlocks.PORTAL_SLOT.left, UIBlocks.PORTAL_SLOT.top));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 6, UIBlocks.DRILL_SLOT.left, UIBlocks.DRILL_SLOT.top));
        if (Config.isExtendedMod()) {
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 3, UIBlocks.COOL_SLOT.left, UIBlocks.COOL_SLOT.top));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.blockEntity.inventory, 4, UIBlocks.CATA_SLOT.left, UIBlocks.CATA_SLOT.top));
        }
        if ((modContainer = this.blockEntity) instanceof MinerBlockEntity) {
            MinerBlockEntity miner = (MinerBlockEntity)modContainer;
            this.addDataSlots(miner);
        }
    }

    private void addDataSlots(final MinerBlockEntity miner) {
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.coolant;
            }

            public void set(int value) {
                miner.coolant = value;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.redstone;
            }

            public void set(int value) {
                miner.redstone = value;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return (int)miner.progress;
            }

            public void set(int value) {
                miner.progress = value;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.working ? 1 : 0;
            }

            public void set(int value) {
                miner.working = value != 0;
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.fuelLow;
            }

            public void set(int value) {
                value = miner.fuel.getEnergyStored() & 0xFFFF0000 | (short)value & 0xFFFF;
                miner.fuel = new EnergyStorage(((Integer)Config.FUEL_CAPACITY.get()).intValue(), 0, 0, value);
            }
        });
        this.addDataSlot(new DataSlot(this){

            public int get() {
                return miner.fuelHigh;
            }

            public void set(int value) {
                value = miner.fuel.getEnergyStored() & 0xFFFF | value << 16;
                miner.fuel = new EnergyStorage(((Integer)Config.FUEL_CAPACITY.get()).intValue(), 0, 0, value);
            }
        });
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        int HOTBAR_SLOT_COUNT = 9;
        int PLAYER_INVENTORY_ROW_COUNT = 3;
        int PLAYER_INVENTORY_COLUMN_COUNT = 9;
        int PLAYER_INVENTORY_SLOT_COUNT = PLAYER_INVENTORY_COLUMN_COUNT * PLAYER_INVENTORY_ROW_COUNT;
        int VANILLA_SLOT_COUNT = HOTBAR_SLOT_COUNT + PLAYER_INVENTORY_SLOT_COUNT;
        int VANILLA_FIRST_SLOT_INDEX = 0;
        int TE_INVENTORY_FIRST_SLOT_INDEX = VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT;
        int TE_INVENTORY_SLOT_COUNT = Config.isExtendedMod() ? 7 : 5;
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, TE_INVENTORY_FIRST_SLOT_INDEX, TE_INVENTORY_FIRST_SLOT_INDEX + TE_INVENTORY_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < TE_INVENTORY_FIRST_SLOT_INDEX + TE_INVENTORY_SLOT_COUNT) {
            if (!this.moveItemStackTo(sourceStack, VANILLA_FIRST_SLOT_INDEX, VANILLA_FIRST_SLOT_INDEX + VANILLA_SLOT_COUNT, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return MinerMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)((Block)SimpleStationsMiner.MINER_BLOCK.get()));
    }

    private void addPlayerInventory(Inventory inventory) {
        for (int k = 0; k < 3; ++k) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + k * 9 + 9, 8 + j * 18, 84 + k * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inventory) {
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)inventory, j, 8 + j * 18, 142));
        }
    }
}

