/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.screen;

import com.ave.simplestationsminer.Config;
import com.ave.simplestationsminer.blockentity.MinerBlockEntity;
import com.ave.simplestationsminer.blockentity.ModContainer;
import com.ave.simplestationsminer.screen.MinerMenu;
import com.ave.simplestationsminer.uihelpers.NumToString;
import com.ave.simplestationsminer.uihelpers.UIBlocks;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class MinerScreen
extends AbstractContainerScreen<MinerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"textures/gui/base_miner_gui.png");
    private static final ResourceLocation TEXTURE_MIN = ResourceLocation.fromNamespaceAndPath((String)"simplestationsminer", (String)"textures/gui/base_miner_gui_min.png");

    public MinerScreen(MinerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.render(gfx, mouseX, mouseY, partialTicks);
        this.renderTooltip(gfx, mouseX, mouseY);
        ModContainer modContainer = ((MinerMenu)this.menu).blockEntity;
        if (!(modContainer instanceof MinerBlockEntity)) {
            return;
        }
        MinerBlockEntity miner = (MinerBlockEntity)modContainer;
        int startX = (this.width - this.imageWidth) / 2;
        int startY = (this.height - this.imageHeight) / 2;
        if (UIBlocks.FUEL_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String fuelPart = NumToString.parse(miner.fuel.getEnergyStored(), "RF / ") + NumToString.parse((Integer)Config.FUEL_CAPACITY.get(), "RF");
            List<Component> fuelText = Arrays.asList(Component.translatable((String)"screen.simplestationsminer.fuel"), Component.literal((String)fuelPart));
            gfx.renderComponentTooltip(this.font, fuelText, mouseX, mouseY);
        }
        if (Config.isExtendedMod() && UIBlocks.COOL_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String coolantPart = miner.coolant + " / " + String.valueOf(Config.MAX_COOLANT.get());
            List<Component> coolantText = Arrays.asList(Component.translatable((String)"screen.simplestationsminer.coolant"), Component.literal((String)coolantPart));
            gfx.renderComponentTooltip(this.font, coolantText, mouseX, mouseY);
        }
        if (Config.isExtendedMod() && UIBlocks.CATA_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            String redstonePart = miner.redstone + " / " + String.valueOf(Config.MAX_CATALYST.get());
            List<Component> redstoneText = Arrays.asList(Component.translatable((String)"screen.simplestationsminer.catalysis"), Component.literal((String)redstonePart));
            gfx.renderComponentTooltip(this.font, redstoneText, mouseX, mouseY);
        }
        if (miner.progress > 0.0f && UIBlocks.PROGRESS_BAR.isHovered(mouseX - startX, mouseY - startY)) {
            int progressPart = (int)Math.ceil(100.0f * miner.progress / (float)((Integer)Config.MAX_PROGRESS.get()).intValue());
            gfx.renderTooltip(this.font, (Component)Component.literal((String)(progressPart + "%")), mouseX, mouseY);
        }
        if (miner.type == null && !miner.invalidDepth && UIBlocks.FILTER_SLOT.isHovered(mouseX - startX, mouseY - startY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)"screen.simplestationsminer.filter"), mouseX, mouseY);
        }
        if (!miner.hasNetherUpdate && UIBlocks.PORTAL_SLOT.isHovered(mouseX - startX, mouseY - startY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)"screen.simplestationsminer.need_portal"), mouseX, mouseY);
        }
        if (miner.drillCount == 0 && UIBlocks.DRILL_SLOT.isHovered(mouseX - startX, mouseY - startY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)"screen.simplestationsminer.need_drill"), mouseX, mouseY);
        }
        if (miner.invalidDepth && UIBlocks.ERROR.isHovered(mouseX - startX, mouseY - startY)) {
            gfx.renderTooltip(this.font, (Component)Component.translatable((String)"screen.simplestationsminer.depthError"), mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics graphics, float tick, int mx, int my) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)(Config.isExtendedMod() ? TEXTURE : TEXTURE_MIN));
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        graphics.blit(Config.isExtendedMod() ? TEXTURE : TEXTURE_MIN, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        MutableComponent title = Component.translatable((String)"screen.simplestationsminer.miner");
        int textWidth = this.font.width((FormattedText)title);
        int centerX = this.width / 2 - textWidth / 2;
        graphics.drawString(this.font, (Component)title, centerX, y + 6, 0x222222, false);
        ModContainer modContainer = ((MinerMenu)this.menu).blockEntity;
        if (!(modContainer instanceof MinerBlockEntity)) {
            return;
        }
        MinerBlockEntity miner = (MinerBlockEntity)modContainer;
        int tickAlpha = 96 + (int)(63.0 * Math.sin((double)System.currentTimeMillis() / 400.0));
        int borderColor = tickAlpha << 24 | 0xFF0000;
        float progressPart = miner.progress / (float)((Integer)Config.MAX_PROGRESS.get()).intValue();
        UIBlocks.PROGRESS_BAR.drawProgressToRight(graphics, x, y, progressPart, -3342627);
        if (miner.invalidDepth) {
            MutableComponent error = Component.literal((String)("Y > " + String.valueOf(Config.MAX_Y.get())));
            UIBlocks.ERROR.drawTextRight(graphics, x, y, this.font, borderColor, (Component)error);
            return;
        }
        float fuelPart = (float)miner.fuel.getEnergyStored() / (float)((Integer)Config.FUEL_CAPACITY.get()).intValue();
        UIBlocks.FUEL_BAR.drawProgressToTop(graphics, x, y, fuelPart, -1440590558);
        if (fuelPart == 0.0f) {
            UIBlocks.FUEL_SLOT.drawBorder(graphics, x, y, borderColor);
        }
        if (miner.drillCount == 0) {
            UIBlocks.DRILL_SLOT.drawBorder(graphics, x, y, borderColor);
        }
        if (!miner.isValidWorld()) {
            UIBlocks.PORTAL_SLOT.drawBorder(graphics, x, y, borderColor);
        }
        if (!Config.isExtendedMod()) {
            return;
        }
        float coolantPart = (float)miner.coolant / (float)((Integer)Config.MAX_COOLANT.get()).intValue();
        UIBlocks.COOL_BAR.drawProgressToTop(graphics, x, y, coolantPart, -1439485014);
        float redstonePart = (float)miner.redstone / (float)((Integer)Config.MAX_CATALYST.get()).intValue();
        UIBlocks.CATA_BAR.drawProgressToTop(graphics, x, y, redstonePart, -1430576623);
        if (coolantPart == 0.0f) {
            UIBlocks.COOL_SLOT.drawBorder(graphics, x, y, borderColor);
        }
        if (redstonePart == 0.0f) {
            UIBlocks.CATA_SLOT.drawBorder(graphics, x, y, borderColor);
        }
    }
}

