/*
 * Decompiled with CFR 0.152.
 */
package com.ave.simplestationsminer.uihelpers;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class Square {
    public final int left;
    public final int top;
    public final int right;
    public final int bottom;
    public final int width;
    public final int height;

    public Square(int x, int y, int w, int h) {
        this.left = x;
        this.top = y;
        this.width = w;
        this.height = h;
        this.right = w + x;
        this.bottom = h + y;
    }

    public boolean isHovered(int x, int y) {
        return x < this.right && x >= this.left && y >= this.top && y < this.bottom;
    }

    public boolean isHovered(double x, double y) {
        return x < (double)this.right && x >= (double)this.left && y >= (double)this.top && y < (double)this.bottom;
    }

    public void drawBorder(GuiGraphics g, int x, int y, int color) {
        g.fill(x += this.left, y += this.top, x + this.width, y + 1, color);
        g.fill(x, y + this.height - 1, x + this.width, y + this.height, color);
        g.fill(x, y, x + 1, y + this.height, color);
        g.fill(x + this.width - 1, y, x + this.width, y + this.height, color);
    }

    public void drawProgressToRight(GuiGraphics g, int x, int y, float percent, int color) {
        int end = this.left + Math.round(percent * (float)this.width);
        g.fill(x + this.left, y + this.top, x + end, y + this.bottom, color);
    }

    public void drawProgressToTop(GuiGraphics g, int x, int y, float percent, int color) {
        int start = this.bottom - Math.round(percent * (float)this.height);
        g.fill(x + this.left, y + start, x + this.right, y + this.bottom, color);
    }

    public void drawTextRight(GuiGraphics g, int x, int y, Font font, int color, Component text) {
        g.drawString(font, text, x + this.right - font.width((FormattedText)text), y + this.top, color, false);
    }
}

