/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.jadevs.mixin;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import snownee.jade.overlay.RayTracing;

@Mixin(value={RayTracing.class})
public class MixinRayTracing {
    @Unique
    private static final EntityTypeTest<Entity, Entity> ANY_ENTITY = new EntityTypeTest<Entity, Entity>(){

        public Entity tryCast(Entity entity) {
            return entity;
        }

        public Class<? extends Entity> m_142225_() {
            return Entity.class;
        }
    };

    @Inject(method={"getEntityHitResult"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private static void getEntityHitResult(Level level, Entity raycaster, Vec3 start, Vec3 end, AABB checkBox_, Predicate<Entity> filter, CallbackInfoReturnable<EntityHitResult> cir) {
        start = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)start);
        end = VSGameUtilsKt.toWorldCoordinates((Level)level, (Vec3)end);
        AABB checkBox = new AABB(start, end);
        double distance = Double.MAX_VALUE;
        Entity result = null;
        Vec3 hitPos = null;
        Vector3d tmp = new Vector3d();
        for (Entity target : level.m_6249_(raycaster, checkBox, filter)) {
            double dist;
            Vec3 end1;
            Vec3 start1;
            Ship ship;
            AABB targetBox = target.m_20191_();
            if (targetBox.m_82309_() < 0.3) {
                targetBox = targetBox.m_82400_(0.3);
            }
            if ((ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)target.m_20183_())) != null) {
                ship.getWorldToShip().transformPosition(tmp.set(start.f_82479_, start.f_82480_, start.f_82481_));
                start1 = new Vec3(tmp.x, tmp.y, tmp.z);
                ship.getWorldToShip().transformPosition(tmp.set(end.f_82479_, end.f_82480_, end.f_82481_));
                end1 = new Vec3(tmp.x, tmp.y, tmp.z);
            } else {
                start1 = start;
                end1 = end;
            }
            if (targetBox.m_82390_(start1)) {
                cir.setReturnValue((Object)new EntityHitResult(target, start));
                return;
            }
            Vec3 pos = targetBox.m_82371_(start1, end1).orElse(null);
            if (pos == null || (dist = start1.m_82557_(pos)) > distance) continue;
            distance = dist;
            result = target;
            if (ship != null) {
                ship.getShipToWorld().transformPosition(tmp.set(pos.f_82479_, pos.f_82480_, pos.f_82481_));
                hitPos = new Vec3(tmp.x, tmp.y, tmp.z);
                continue;
            }
            hitPos = pos;
        }
        if (result != null) {
            cir.setReturnValue((Object)new EntityHitResult(result, hitPos));
        }
    }
}

